rule win_comlook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.comlook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.comlook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd2 3bf4 e8???????? b807000000 e9???????? 837db000 741f }
            // n = 7, score = 100
            //   ffd2                 | call                edx
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   b807000000           | mov                 eax, 7
            //   e9????????           |                     
            //   837db000             | cmp                 dword ptr [ebp - 0x50], 0
            //   741f                 | je                  0x21

        $sequence_1 = { ff15???????? 83c404 3bf4 e8???????? 8b4508 c7400800000000 33c9 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c7400800000000       | mov                 dword ptr [eax + 8], 0
            //   33c9                 | xor                 ecx, ecx

        $sequence_2 = { e9???????? 8b55f8 83ba5007000000 750a 837dbc00 0f8438020000 c78554ffffff00000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   83ba5007000000       | cmp                 dword ptr [edx + 0x750], 0
            //   750a                 | jne                 0xc
            //   837dbc00             | cmp                 dword ptr [ebp - 0x44], 0
            //   0f8438020000         | je                  0x23e
            //   c78554ffffff00000000     | mov    dword ptr [ebp - 0xac], 0

        $sequence_3 = { e9???????? 68df010000 68???????? 6a0c 6a05 e8???????? 8b87c4000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   68df010000           | push                0x1df
            //   68????????           |                     
            //   6a0c                 | push                0xc
            //   6a05                 | push                5
            //   e8????????           |                     
            //   8b87c4000000         | mov                 eax, dword ptr [edi + 0xc4]

        $sequence_4 = { eb0a c785c8feffff44f72010 8b5508 83ba7403000000 7411 8b4508 8b8874030000 }
            // n = 7, score = 100
            //   eb0a                 | jmp                 0xc
            //   c785c8feffff44f72010     | mov    dword ptr [ebp - 0x138], 0x1020f744
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83ba7403000000       | cmp                 dword ptr [edx + 0x374], 0
            //   7411                 | je                  0x13
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b8874030000         | mov                 ecx, dword ptr [eax + 0x374]

        $sequence_5 = { c745f000000000 6a00 e8???????? 83c404 8945e8 8955ec c745e400000000 }
            // n = 7, score = 100
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0

        $sequence_6 = { eb03 894dbc 8b4de4 8b55d0 8bc2 83f910 7303 }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   894dbc               | mov                 dword ptr [ebp - 0x44], ecx
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   8b55d0               | mov                 edx, dword ptr [ebp - 0x30]
            //   8bc2                 | mov                 eax, edx
            //   83f910               | cmp                 ecx, 0x10
            //   7303                 | jae                 5

        $sequence_7 = { eb0a c785b4eeffff518c1e10 837d1400 740c c785b0eeffff70191e10 eb0a c785b0eeffff518c1e10 }
            // n = 7, score = 100
            //   eb0a                 | jmp                 0xc
            //   c785b4eeffff518c1e10     | mov    dword ptr [ebp - 0x114c], 0x101e8c51
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0
            //   740c                 | je                  0xe
            //   c785b0eeffff70191e10     | mov    dword ptr [ebp - 0x1150], 0x101e1970
            //   eb0a                 | jmp                 0xc
            //   c785b0eeffff518c1e10     | mov    dword ptr [ebp - 0x1150], 0x101e8c51

        $sequence_8 = { e9???????? 6a02 68???????? 6a01 8b5508 52 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6a02                 | push                2
            //   68????????           |                     
            //   6a01                 | push                1
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_9 = { eb11 8b5518 8b4510 33c9 3b4218 0f9fc1 894ddc }
            // n = 7, score = 100
            //   eb11                 | jmp                 0x13
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   33c9                 | xor                 ecx, ecx
            //   3b4218               | cmp                 eax, dword ptr [edx + 0x18]
            //   0f9fc1               | setg                cl
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx

    condition:
        7 of them and filesize < 4553728
}