rule win_compfun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.compfun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.compfun"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 56 e8???????? 83c40c c7460c57202020 c70652656745 c746046e756d4b }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c7460c57202020       | mov                 dword ptr [esi + 0xc], 0x20202057
            //   c70652656745         | mov                 dword ptr [esi], 0x45676552
            //   c746046e756d4b       | mov                 dword ptr [esi + 4], 0x4b6d756e

        $sequence_1 = { c7460475705072 c746086976696c c7460c65676556 c74610616c7565 c6461500 8bc6 5e }
            // n = 7, score = 300
            //   c7460475705072       | mov                 dword ptr [esi + 4], 0x72507075
            //   c746086976696c       | mov                 dword ptr [esi + 8], 0x6c697669
            //   c7460c65676556       | mov                 dword ptr [esi + 0xc], 0x56656765
            //   c74610616c7565       | mov                 dword ptr [esi + 0x10], 0x65756c61
            //   c6461500             | mov                 byte ptr [esi + 0x15], 0
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_2 = { c7460c62757465 c6461200 8bc6 5e 5d }
            // n = 5, score = 300
            //   c7460c62757465       | mov                 dword ptr [esi + 0xc], 0x65747562
            //   c6461200             | mov                 byte ptr [esi + 0x12], 0
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_3 = { 742d 53 8d85d8fdffff 50 a1???????? }
            // n = 5, score = 300
            //   742d                 | je                  0x2f
            //   53                   | push                ebx
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   50                   | push                eax
            //   a1????????           |                     

        $sequence_4 = { c746144533442d c7461843343537 c7461c39323931 c7462036393245 c6462500 }
            // n = 5, score = 300
            //   c746144533442d       | mov                 dword ptr [esi + 0x14], 0x2d443345
            //   c7461843343537       | mov                 dword ptr [esi + 0x18], 0x37353443
            //   c7461c39323931       | mov                 dword ptr [esi + 0x1c], 0x31393239
            //   c7462036393245       | mov                 dword ptr [esi + 0x20], 0x45323936
            //   c6462500             | mov                 byte ptr [esi + 0x25], 0

        $sequence_5 = { e8???????? 59 50 57 ffd3 894650 85c0 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   894650               | mov                 dword ptr [esi + 0x50], eax
            //   85c0                 | test                eax, eax

        $sequence_6 = { 83c40c c746086c655720 c70643726561 c7460474654669 }
            // n = 4, score = 300
            //   83c40c               | add                 esp, 0xc
            //   c746086c655720       | mov                 dword ptr [esi + 8], 0x2057656c
            //   c70643726561         | mov                 dword ptr [esi], 0x61657243
            //   c7460474654669       | mov                 dword ptr [esi + 4], 0x69466574

        $sequence_7 = { e8???????? 83c40c c706466c7573 c746046846696c c7460865427566 c7460c66657273 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c706466c7573         | mov                 dword ptr [esi], 0x73756c46
            //   c746046846696c       | mov                 dword ptr [esi + 4], 0x6c694668
            //   c7460865427566       | mov                 dword ptr [esi + 8], 0x66754265
            //   c7460c66657273       | mov                 dword ptr [esi + 0xc], 0x73726566

        $sequence_8 = { 488b8424a0000000 ff5030 85c0 7508 }
            // n = 4, score = 100
            //   488b8424a0000000     | je                  0x11
            //   ff5030               | mov                 dword ptr [esp + 0x44], 1
            //   85c0                 | jmp                 0x12
            //   7508                 | dec                 eax

        $sequence_9 = { 837c2428ff 740a c744244401000000 eb08 }
            // n = 4, score = 100
            //   837c2428ff           | dec                 eax
            //   740a                 | mov                 eax, dword ptr [esp]
            //   c744244401000000     | mov                 dword ptr [eax], 0x68637673
            //   eb08                 | cmp                 dword ptr [esp + 0x28], -1

        $sequence_10 = { 488b842438010000 8908 488b842438010000 8b08 }
            // n = 4, score = 100
            //   488b842438010000     | mov                 eax, dword ptr [esp + 0x38]
            //   8908                 | mov                 dword ptr [esp + 0x20], eax
            //   488b842438010000     | dec                 esp
            //   8b08                 | mov                 ebx, eax

        $sequence_11 = { ff15???????? 4c8bd8 488b442460 4c895848 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   4c8bd8               | dec                 eax
            //   488b442460           | cmp                 dword ptr [ecx + edx*8], eax
            //   4c895848             | jne                 0x10

        $sequence_12 = { 8b9424a4000000 488b8c2498000000 488b442438 420fb60400 }
            // n = 4, score = 100
            //   8b9424a4000000       | dec                 eax
            //   488b8c2498000000     | mov                 eax, dword ptr [esp + 0x60]
            //   488b442438           | dec                 esp
            //   420fb60400           | mov                 dword ptr [eax + 0x48], ebx

        $sequence_13 = { 488b442420 48890424 488b0424 c70073766368 }
            // n = 4, score = 100
            //   488b442420           | dec                 eax
            //   48890424             | mov                 eax, dword ptr [esp + 0x20]
            //   488b0424             | dec                 eax
            //   c70073766368         | mov                 dword ptr [esp], eax

        $sequence_14 = { 483904d1 750a 8b442438 89442420 }
            // n = 4, score = 100
            //   483904d1             | mov                 eax, dword ptr [esp + 0xa0]
            //   750a                 | call                dword ptr [eax + 0x30]
            //   8b442438             | test                eax, eax
            //   89442420             | jne                 0xc

        $sequence_15 = { 488b442450 0fb600 3de9000000 740f }
            // n = 4, score = 100
            //   488b442450           | dec                 eax
            //   0fb600               | mov                 eax, dword ptr [esp + 0x138]
            //   3de9000000           | mov                 dword ptr [eax], ecx
            //   740f                 | dec                 eax

    condition:
        7 of them and filesize < 402432
}