rule win_concealment_troy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.concealment_troy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.concealment_troy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744244000000000 ff15???????? 85c0 0f844cffffff 8b542424 }
            // n = 5, score = 100
            //   c744244000000000     | mov                 dword ptr [esp + 0x40], 0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f844cffffff         | je                  0xffffff52
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]

        $sequence_1 = { 7530 8b54240c 52 ff15???????? 53 }
            // n = 5, score = 100
            //   7530                 | jne                 0x32
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   53                   | push                ebx

        $sequence_2 = { 8bc8 83e103 f3a4 8d542418 8d8c2430090000 e8???????? 85c0 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   8d8c2430090000       | lea                 ecx, [esp + 0x930]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 3acb 75f6 6804010000 8d8c2424010000 53 }
            // n = 5, score = 100
            //   3acb                 | cmp                 cl, bl
            //   75f6                 | jne                 0xfffffff8
            //   6804010000           | push                0x104
            //   8d8c2424010000       | lea                 ecx, [esp + 0x124]
            //   53                   | push                ebx

        $sequence_4 = { f3a5 66a5 83c40c a4 8d4c2418 8d642400 8a01 }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   83c40c               | add                 esp, 0xc
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   8d642400             | lea                 esp, [esp]
            //   8a01                 | mov                 al, byte ptr [ecx]

        $sequence_5 = { 85c0 0f8476ffffff 6a00 6a08 6a00 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f8476ffffff         | je                  0xffffff7c
            //   6a00                 | push                0
            //   6a08                 | push                8
            //   6a00                 | push                0

        $sequence_6 = { e8???????? 83c414 ebd0 8bc8 c1f905 8d3c8da0774100 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   ebd0                 | jmp                 0xffffffd2
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8d3c8da0774100       | lea                 edi, [ecx*4 + 0x4177a0]

        $sequence_7 = { 8d8c2470050000 68???????? 51 e8???????? 8d842478050000 83c418 8d5001 }
            // n = 7, score = 100
            //   8d8c2470050000       | lea                 ecx, [esp + 0x570]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d842478050000       | lea                 eax, [esp + 0x578]
            //   83c418               | add                 esp, 0x18
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_8 = { b87c130000 e8???????? a1???????? 33c4 89842478130000 53 }
            // n = 6, score = 100
            //   b87c130000           | mov                 eax, 0x137c
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842478130000       | mov                 dword ptr [esp + 0x1378], eax
            //   53                   | push                ebx

        $sequence_9 = { 52 889c242c010000 e8???????? 6807020000 8d842441090000 53 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   889c242c010000       | mov                 byte ptr [esp + 0x12c], bl
            //   e8????????           |                     
            //   6807020000           | push                0x207
            //   8d842441090000       | lea                 eax, [esp + 0x941]
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 229376
}