rule win_conficker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.conficker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.conficker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81f9a9fe0000 743b 8bce 81e1fffe0000 81f9c6120000 }
            // n = 5, score = 300
            //   81f9a9fe0000         | cmp                 ecx, 0xfea9
            //   743b                 | je                  0x3d
            //   8bce                 | mov                 ecx, esi
            //   81e1fffe0000         | and                 ecx, 0xfeff
            //   81f9c6120000         | cmp                 ecx, 0x12c6

        $sequence_1 = { 0fb6d3 8b5c9008 46 3b7510 891f 894c9008 }
            // n = 6, score = 300
            //   0fb6d3               | movzx               edx, bl
            //   8b5c9008             | mov                 ebx, dword ptr [eax + edx*4 + 8]
            //   46                   | inc                 esi
            //   3b7510               | cmp                 esi, dword ptr [ebp + 0x10]
            //   891f                 | mov                 dword ptr [edi], ebx
            //   894c9008             | mov                 dword ptr [eax + edx*4 + 8], ecx

        $sequence_2 = { f2ae 61 7502 4a 4a 3c09 }
            // n = 6, score = 300
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   61                   | popal               
            //   7502                 | jne                 4
            //   4a                   | dec                 edx
            //   4a                   | dec                 edx
            //   3c09                 | cmp                 al, 9

        $sequence_3 = { ff15???????? 8945e4 8365fc00 85c0 7420 68???????? }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   68????????           |                     

        $sequence_4 = { 85c0 750a 2145fc c745f8b0ae6243 ff15???????? 3345f8 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   2145fc               | and                 dword ptr [ebp - 4], eax
            //   c745f8b0ae6243       | mov                 dword ptr [ebp - 8], 0x4362aeb0
            //   ff15????????         |                     
            //   3345f8               | xor                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 743b 8bce 81e1fffe0000 81f9c6120000 }
            // n = 4, score = 300
            //   743b                 | je                  0x3d
            //   8bce                 | mov                 ecx, esi
            //   81e1fffe0000         | and                 ecx, 0xfeff
            //   81f9c6120000         | cmp                 ecx, 0x12c6

        $sequence_6 = { 894d08 8b0e 894c9808 02ca 8916 8b750c }
            // n = 6, score = 300
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   894c9808             | mov                 dword ptr [eax + ebx*4 + 8], ecx
            //   02ca                 | add                 cl, dl
            //   8916                 | mov                 dword ptr [esi], edx
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]

        $sequence_7 = { 8955fc bfffffff7f 23d7 8945f0 8955f4 }
            // n = 5, score = 300
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   bfffffff7f           | mov                 edi, 0x7fffffff
            //   23d7                 | and                 edx, edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx

        $sequence_8 = { 395df8 7507 c745fc01000000 57 }
            // n = 4, score = 300
            //   395df8               | cmp                 dword ptr [ebp - 8], ebx
            //   7507                 | jne                 9
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   57                   | push                edi

        $sequence_9 = { 81e1fffe0000 81f9c6120000 742b 8bce }
            // n = 4, score = 300
            //   81e1fffe0000         | and                 ecx, 0xfeff
            //   81f9c6120000         | cmp                 ecx, 0x12c6
            //   742b                 | je                  0x2d
            //   8bce                 | mov                 ecx, esi

    condition:
        7 of them and filesize < 335872
}