rule win_conti_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.conti."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.conti"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7542 53 bb0e000000 57 8d7e01 8d7371 }
            // n = 6, score = 600
            //   7542                 | jne                 0x44
            //   53                   | push                ebx
            //   bb0e000000           | mov                 ebx, 0xe
            //   57                   | push                edi
            //   8d7e01               | lea                 edi, [esi + 1]
            //   8d7371               | lea                 esi, [ebx + 0x71]

        $sequence_1 = { 56 8bf1 8975fc 803e00 7542 53 bb0e000000 }
            // n = 7, score = 600
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7542                 | jne                 0x44
            //   53                   | push                ebx
            //   bb0e000000           | mov                 ebx, 0xe

        $sequence_2 = { 8d7f01 0fb6c0 b957000000 2bc8 }
            // n = 4, score = 600
            //   8d7f01               | lea                 edi, [edi + 1]
            //   0fb6c0               | movzx               eax, al
            //   b957000000           | mov                 ecx, 0x57
            //   2bc8                 | sub                 ecx, eax

        $sequence_3 = { 0f1f4000 8a07 8d7f01 0fb6c0 b966000000 2bc8 }
            // n = 6, score = 600
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8a07                 | mov                 al, byte ptr [edi]
            //   8d7f01               | lea                 edi, [edi + 1]
            //   0fb6c0               | movzx               eax, al
            //   b966000000           | mov                 ecx, 0x66
            //   2bc8                 | sub                 ecx, eax

        $sequence_4 = { 8d7f01 0fb6c0 b927000000 2bc8 }
            // n = 4, score = 600
            //   8d7f01               | lea                 edi, [edi + 1]
            //   0fb6c0               | movzx               eax, al
            //   b927000000           | mov                 ecx, 0x27
            //   2bc8                 | sub                 ecx, eax

        $sequence_5 = { 8d7f01 0fb6c0 b978000000 2bc8 }
            // n = 4, score = 600
            //   8d7f01               | lea                 edi, [edi + 1]
            //   0fb6c0               | movzx               eax, al
            //   b978000000           | mov                 ecx, 0x78
            //   2bc8                 | sub                 ecx, eax

        $sequence_6 = { 56 57 bf0e000000 8d7101 }
            // n = 4, score = 600
            //   56                   | push                esi
            //   57                   | push                edi
            //   bf0e000000           | mov                 edi, 0xe
            //   8d7101               | lea                 esi, [ecx + 1]

        $sequence_7 = { 8d7f01 0fb6c0 b918000000 2bc8 }
            // n = 4, score = 600
            //   8d7f01               | lea                 edi, [edi + 1]
            //   0fb6c0               | movzx               eax, al
            //   b918000000           | mov                 ecx, 0x18
            //   2bc8                 | sub                 ecx, eax

        $sequence_8 = { ff75fc ff15???????? e9???????? 6800800000 }
            // n = 4, score = 400
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   e9????????           |                     
            //   6800800000           | push                0x8000

        $sequence_9 = { 57 56 ff15???????? ff75f8 56 ff15???????? }
            // n = 6, score = 400
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_10 = { 7605 b800005000 6a00 8d4c2418 }
            // n = 4, score = 400
            //   7605                 | jbe                 7
            //   b800005000           | mov                 eax, 0x500000
            //   6a00                 | push                0
            //   8d4c2418             | lea                 ecx, [esp + 0x18]

        $sequence_11 = { ffd0 85c0 7519 c705????????0a000000 e9???????? b801000000 e9???????? }
            // n = 7, score = 400
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7519                 | jne                 0x1b
            //   c705????????0a000000     |     
            //   e9????????           |                     
            //   b801000000           | mov                 eax, 1
            //   e9????????           |                     

        $sequence_12 = { 6810660000 ff7508 ff15???????? 85c0 }
            // n = 4, score = 400
            //   6810660000           | push                0x6610
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_13 = { e8???????? 8bb6007d0000 85f6 75ef }
            // n = 4, score = 400
            //   e8????????           |                     
            //   8bb6007d0000         | mov                 esi, dword ptr [esi + 0x7d00]
            //   85f6                 | test                esi, esi
            //   75ef                 | jne                 0xfffffff1

        $sequence_14 = { ff75f8 ff15???????? 85c0 7508 6a01 ff15???????? 6aff }
            // n = 7, score = 400
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   6aff                 | push                -1

        $sequence_15 = { 7411 a801 740d 83f001 50 ff7608 ff15???????? }
            // n = 7, score = 400
            //   7411                 | je                  0x13
            //   a801                 | test                al, 1
            //   740d                 | je                  0xf
            //   83f001               | xor                 eax, 1
            //   50                   | push                eax
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff15????????         |                     

        $sequence_16 = { 53 56 8bf1 57 ff7608 ff15???????? }
            // n = 6, score = 400
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff15????????         |                     

        $sequence_17 = { 3ce9 7412 3cff 0f859d000000 807f0125 0f8593000000 }
            // n = 6, score = 400
            //   3ce9                 | cmp                 al, 0xe9
            //   7412                 | je                  0x14
            //   3cff                 | cmp                 al, 0xff
            //   0f859d000000         | jne                 0xa3
            //   807f0125             | cmp                 byte ptr [edi + 1], 0x25
            //   0f8593000000         | jne                 0x99

        $sequence_18 = { 85c0 742b 03f0 03d8 }
            // n = 4, score = 300
            //   85c0                 | inc                 esp
            //   742b                 | mov                 eax, esi
            //   03f0                 | call                eax
            //   03d8                 | test                eax, eax

        $sequence_19 = { 41b901000000 4533c0 488bd3 488bce }
            // n = 4, score = 300
            //   41b901000000         | cmp                 edi, ebx
            //   4533c0               | je                  0x14
            //   488bd3               | dec                 esp
            //   488bce               | cmp                 esi, ebx

        $sequence_20 = { 410f4ff5 488bcb 448bc6 ffd0 }
            // n = 4, score = 300
            //   410f4ff5             | inc                 ecx
            //   488bcb               | cmovg               esi, ebp
            //   448bc6               | dec                 eax
            //   ffd0                 | mov                 ecx, ebx

        $sequence_21 = { 49f7e8 4903d0 48c1fa06 488bca 48c1e93f 4803d1 488d3c92 }
            // n = 7, score = 300
            //   49f7e8               | inc                 ecx
            //   4903d0               | mov                 ecx, 1
            //   48c1fa06             | inc                 ebp
            //   488bca               | xor                 eax, eax
            //   48c1e93f             | dec                 eax
            //   4803d1               | mov                 edx, ebx
            //   488d3c92             | dec                 eax

        $sequence_22 = { 72c3 488b7c2448 b801000000 488b742440 4883c430 }
            // n = 5, score = 300
            //   72c3                 | je                  0x2d
            //   488b7c2448           | add                 esi, eax
            //   b801000000           | add                 ebx, eax
            //   488b742440           | jb                  0xffffffc5
            //   4883c430             | dec                 eax

        $sequence_23 = { ffd0 4c3beb 740f 4c3bfb 740a 4c3bf3 }
            // n = 6, score = 300
            //   ffd0                 | mov                 edi, dword ptr [esp + 0x48]
            //   4c3beb               | mov                 eax, 1
            //   740f                 | dec                 eax
            //   4c3bfb               | mov                 esi, dword ptr [esp + 0x40]
            //   740a                 | dec                 eax
            //   4c3bf3               | add                 esp, 0x30

        $sequence_24 = { 4833c4 4889442438 4533e4 418be8 4489642430 4c8bfa 4c8bf1 }
            // n = 7, score = 300
            //   4833c4               | mov                 ecx, esi
            //   4889442438           | mov                 edx, 0x40
            //   4533e4               | mov                 ecx, edx
            //   418be8               | call                eax
            //   4489642430           | dec                 eax
            //   4c8bfa               | mov                 ebx, eax
            //   4c8bf1               | dec                 eax

        $sequence_25 = { 8b4c2430 8b05???????? 03c7 03c8 894c2430 8b442430 }
            // n = 6, score = 300
            //   8b4c2430             | call                eax
            //   8b05????????         |                     
            //   03c7                 | dec                 esp
            //   03c8                 | cmp                 ebp, ebx
            //   894c2430             | je                  0x14
            //   8b442430             | dec                 esp

    condition:
        7 of them and filesize < 520192
}