rule win_cookiebag_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cookiebag."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cookiebag"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? bf???????? 83c9ff 33c0 c644247403 f2ae f7d1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   c644247403           | mov                 byte ptr [esp + 0x74], 3
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_1 = { 83e00f eb02 33c0 0fbe84c1a0e24100 c1f804 83f807 }
            // n = 6, score = 100
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c1a0e24100     | movsx               eax, byte ptr [ecx + eax*8 + 0x41e2a0]
            //   c1f804               | sar                 eax, 4
            //   83f807               | cmp                 eax, 7

        $sequence_2 = { 2bc2 83f801 8a5cbc2c 7705 }
            // n = 4, score = 100
            //   2bc2                 | sub                 eax, edx
            //   83f801               | cmp                 eax, 1
            //   8a5cbc2c             | mov                 bl, byte ptr [esp + edi*4 + 0x2c]
            //   7705                 | ja                  7

        $sequence_3 = { 896c2458 896c245c 741d 8d48ff 8a40ff 84c0 740a }
            // n = 7, score = 100
            //   896c2458             | mov                 dword ptr [esp + 0x58], ebp
            //   896c245c             | mov                 dword ptr [esp + 0x5c], ebp
            //   741d                 | je                  0x1f
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   8a40ff               | mov                 al, byte ptr [eax - 1]
            //   84c0                 | test                al, al
            //   740a                 | je                  0xc

        $sequence_4 = { e9???????? 49 51 e8???????? 83c404 e9???????? 8a8c2484000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e9????????           |                     
            //   8a8c2484000000       | mov                 cl, byte ptr [esp + 0x84]

        $sequence_5 = { 47 83f80b 0f8777020000 ff248509c44100 80fb31 7c0c }
            // n = 6, score = 100
            //   47                   | inc                 edi
            //   83f80b               | cmp                 eax, 0xb
            //   0f8777020000         | ja                  0x27d
            //   ff248509c44100       | jmp                 dword ptr [eax*4 + 0x41c409]
            //   80fb31               | cmp                 bl, 0x31
            //   7c0c                 | jl                  0xe

        $sequence_6 = { e8???????? 8b4c242c 8b442428 45 83c710 e9???????? 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   45                   | inc                 ebp
            //   83c710               | add                 edi, 0x10
            //   e9????????           |                     
            //   50                   | push                eax

        $sequence_7 = { 8bd8 8dbe98000000 6a01 53 8bcf e8???????? 84c0 }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   8dbe98000000         | lea                 edi, [esi + 0x98]
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_8 = { 8bf8 8d9e04010000 6a01 57 8bcb e8???????? 84c0 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   8d9e04010000         | lea                 ebx, [esi + 0x104]
            //   6a01                 | push                1
            //   57                   | push                edi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_9 = { 889c24b8000000 e8???????? 8d44242c 8d4c241c 50 8d542460 51 }
            // n = 7, score = 100
            //   889c24b8000000       | mov                 byte ptr [esp + 0xb8], bl
            //   e8????????           |                     
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   50                   | push                eax
            //   8d542460             | lea                 edx, [esp + 0x60]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 311296
}