rule win_cosmicduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cosmicduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cosmicduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895df4 53 33f6 885dfb ff15???????? 85c0 0f8591000000 }
            // n = 7, score = 100
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   53                   | push                ebx
            //   33f6                 | xor                 esi, esi
            //   885dfb               | mov                 byte ptr [ebp - 5], bl
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8591000000         | jne                 0x97

        $sequence_1 = { eb0e 68???????? 8d85c0f9ffff 50 ffd3 68???????? 8d85d0fdffff }
            // n = 7, score = 100
            //   eb0e                 | jmp                 0x10
            //   68????????           |                     
            //   8d85c0f9ffff         | lea                 eax, [ebp - 0x640]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   68????????           |                     
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]

        $sequence_2 = { 68???????? 8d85f4fdffff 50 ff15???????? 8d85ecfbffff 50 }
            // n = 6, score = 100
            //   68????????           |                     
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   50                   | push                eax

        $sequence_3 = { 7443 68???????? 8d842448020000 50 ffd6 85c0 7438 }
            // n = 7, score = 100
            //   7443                 | je                  0x45
            //   68????????           |                     
            //   8d842448020000       | lea                 eax, [esp + 0x248]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a

        $sequence_4 = { 68???????? 6a01 6a01 68???????? e8???????? ba01000080 8bc8 }
            // n = 7, score = 100
            //   68????????           |                     
            //   6a01                 | push                1
            //   6a01                 | push                1
            //   68????????           |                     
            //   e8????????           |                     
            //   ba01000080           | mov                 edx, 0x80000001
            //   8bc8                 | mov                 ecx, eax

        $sequence_5 = { 668b044510984200 8b4dfc 6689044e 33c0 ff4d0c 75d2 8b4dfc }
            // n = 7, score = 100
            //   668b044510984200     | mov                 ax, word ptr [eax*2 + 0x429810]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   6689044e             | mov                 word ptr [esi + ecx*2], ax
            //   33c0                 | xor                 eax, eax
            //   ff4d0c               | dec                 dword ptr [ebp + 0xc]
            //   75d2                 | jne                 0xffffffd4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_6 = { e8???????? 8b442450 8944240c 8d44240c 50 8bfe 8d442450 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   50                   | push                eax
            //   8bfe                 | mov                 edi, esi
            //   8d442450             | lea                 eax, [esp + 0x50]

        $sequence_7 = { 68???????? 50 6801000080 e8???????? e8???????? 3d09030000 7515 }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   e8????????           |                     
            //   e8????????           |                     
            //   3d09030000           | cmp                 eax, 0x309
            //   7515                 | jne                 0x17

        $sequence_8 = { ff15???????? 83c410 6a00 ff742434 68???????? e8???????? c644245c00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   6a00                 | push                0
            //   ff742434             | push                dword ptr [esp + 0x34]
            //   68????????           |                     
            //   e8????????           |                     
            //   c644245c00           | mov                 byte ptr [esp + 0x5c], 0

        $sequence_9 = { 8d442424 50 8b442424 68???????? 57 895c2448 }
            // n = 6, score = 100
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   68????????           |                     
            //   57                   | push                edi
            //   895c2448             | mov                 dword ptr [esp + 0x48], ebx

    condition:
        7 of them and filesize < 456704
}