rule win_cradlecore_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cradlecore."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cradlecore"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d45d8 c645fc1c 50 e8???????? 8d4590 c645fc1d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   c645fc1c             | mov                 byte ptr [ebp - 4], 0x1c
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   c645fc1d             | mov                 byte ptr [ebp - 4], 0x1d

        $sequence_1 = { 8bf8 e9???????? 8b8528e5ffff 8b0c85f01f4300 8b8524e5ffff f644080480 0f8475030000 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   e9????????           |                     
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   8b0c85f01f4300       | mov                 ecx, dword ptr [eax*4 + 0x431ff0]
            //   8b8524e5ffff         | mov                 eax, dword ptr [ebp - 0x1adc]
            //   f644080480           | test                byte ptr [eax + ecx + 4], 0x80
            //   0f8475030000         | je                  0x37b

        $sequence_2 = { 03d9 014c2410 8b54240c 11442414 2bf1 1bf8 8b422c }
            // n = 7, score = 100
            //   03d9                 | add                 ebx, ecx
            //   014c2410             | add                 dword ptr [esp + 0x10], ecx
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   11442414             | adc                 dword ptr [esp + 0x14], eax
            //   2bf1                 | sub                 esi, ecx
            //   1bf8                 | sbb                 edi, eax
            //   8b422c               | mov                 eax, dword ptr [edx + 0x2c]

        $sequence_3 = { 8d4db0 8945fc e8???????? 8b55fc 8bcf f7d1 }
            // n = 6, score = 100
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bcf                 | mov                 ecx, edi
            //   f7d1                 | not                 ecx

        $sequence_4 = { 8bc3 2b450c 741b 50 }
            // n = 4, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   2b450c               | sub                 eax, dword ptr [ebp + 0xc]
            //   741b                 | je                  0x1d
            //   50                   | push                eax

        $sequence_5 = { 50 51 8d8c248c000000 e8???????? 8b5508 8d4c2468 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8c248c000000       | lea                 ecx, [esp + 0x8c]
            //   e8????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8d4c2468             | lea                 ecx, [esp + 0x68]

        $sequence_6 = { 395c2430 726f 837c243410 8b442420 7304 }
            // n = 5, score = 100
            //   395c2430             | cmp                 dword ptr [esp + 0x30], ebx
            //   726f                 | jb                  0x71
            //   837c243410           | cmp                 dword ptr [esp + 0x34], 0x10
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   7304                 | jae                 6

        $sequence_7 = { c1e606 c1e910 c0e107 8b1485f01f4300 8a443224 }
            // n = 5, score = 100
            //   c1e606               | shl                 esi, 6
            //   c1e910               | shr                 ecx, 0x10
            //   c0e107               | shl                 cl, 7
            //   8b1485f01f4300       | mov                 edx, dword ptr [eax*4 + 0x431ff0]
            //   8a443224             | mov                 al, byte ptr [edx + esi + 0x24]

        $sequence_8 = { 8b7508 6a00 53 8d4c2430 e8???????? 8bc6 8b4c2444 }
            // n = 7, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]

        $sequence_9 = { 59 85c0 7831 8b1cc55c5e4200 6a55 53 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7831                 | js                  0x33
            //   8b1cc55c5e4200       | mov                 ebx, dword ptr [eax*8 + 0x425e5c]
            //   6a55                 | push                0x55
            //   53                   | push                ebx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 450560
}