rule win_crenufs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crenufs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crenufs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 8d4de4 ff15???????? 8b4df4 5f 5e 5b }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   ff15????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_1 = { 8b7610 c744241000000000 3930 770a }
            // n = 4, score = 200
            //   8b7610               | mov                 esi, dword ptr [esi + 0x10]
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   3930                 | cmp                 dword ptr [eax], esi
            //   770a                 | ja                  0xc

        $sequence_2 = { 50 56 8d4de0 ff15???????? 57 68???????? }
            // n = 6, score = 200
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   ff15????????         |                     
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_3 = { 8bf9 56 897c2418 e8???????? 56 ff15???????? }
            // n = 6, score = 200
            //   8bf9                 | mov                 edi, ecx
            //   56                   | push                esi
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   e8????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_4 = { c7461001000000 8bde ff15???????? 392d???????? 7512 8935???????? 892e }
            // n = 7, score = 200
            //   c7461001000000       | mov                 dword ptr [esi + 0x10], 1
            //   8bde                 | mov                 ebx, esi
            //   ff15????????         |                     
            //   392d????????         |                     
            //   7512                 | jne                 0x14
            //   8935????????         |                     
            //   892e                 | mov                 dword ptr [esi], ebp

        $sequence_5 = { 52 8d7e58 6a04 57 50 ffd5 }
            // n = 6, score = 200
            //   52                   | push                edx
            //   8d7e58               | lea                 edi, [esi + 0x58]
            //   6a04                 | push                4
            //   57                   | push                edi
            //   50                   | push                eax
            //   ffd5                 | call                ebp

        $sequence_6 = { 03ca 894c2438 3b4b18 740d 8b4c2454 c74118ccc74000 eb61 }
            // n = 7, score = 200
            //   03ca                 | add                 ecx, edx
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx
            //   3b4b18               | cmp                 ecx, dword ptr [ebx + 0x18]
            //   740d                 | je                  0xf
            //   8b4c2454             | mov                 ecx, dword ptr [esp + 0x54]
            //   c74118ccc74000       | mov                 dword ptr [ecx + 0x18], 0x40c7cc
            //   eb61                 | jmp                 0x63

        $sequence_7 = { ff15???????? 834dfcff 6a01 8d4ddc ff15???????? 8b4df4 8bc6 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   6a01                 | push                1
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   ff15????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 53 50 68???????? 53 ff15???????? 6a01 8d4db0 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   50                   | push                eax
            //   68????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8d4db0               | lea                 ecx, [ebp - 0x50]

        $sequence_9 = { ff15???????? e9???????? a1???????? bf???????? 83c9ff }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   e9????????           |                     
            //   a1????????           |                     
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

    condition:
        7 of them and filesize < 106496
}