rule win_crosswalk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crosswalk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crosswalk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883ec28 4885c9 7402 ffd1 }
            // n = 4, score = 1300
            //   4883ec28             | inc                 ecx
            //   4885c9               | movsx               eax, byte ptr [eax]
            //   7402                 | dec                 ecx
            //   ffd1                 | inc                 eax

        $sequence_1 = { 8bc2 c1e81f 03d0 69c2890e0000 3bc8 }
            // n = 5, score = 1300
            //   8bc2                 | mov                 eax, esi
            //   c1e81f               | xor                 edx, edx
            //   03d0                 | dec                 eax
            //   69c2890e0000         | mov                 ecx, eax
            //   3bc8                 | inc                 ebp

        $sequence_2 = { d3ca 03d0 4183ef01 75ef }
            // n = 4, score = 1300
            //   d3ca                 | add                 edx, eax
            //   03d0                 | inc                 ecx
            //   4183ef01             | mov                 eax, eax
            //   75ef                 | imul                ecx

        $sequence_3 = { 33f6 8d6e20 8bcd e8???????? }
            // n = 4, score = 1300
            //   33f6                 | inc                 eax
            //   8d6e20               | ror                 edx, cl
            //   8bcd                 | add                 edx, eax
            //   e8????????           |                     

        $sequence_4 = { 458d7ee0 418bd7 ff15???????? 4821742420 }
            // n = 4, score = 1300
            //   458d7ee0             | mov                 eax, edx
            //   418bd7               | shr                 eax, 0x1f
            //   ff15????????         |                     
            //   4821742420           | inc                 ebp

        $sequence_5 = { 41b88d56e68c 418bc0 f7e9 03d1 }
            // n = 4, score = 1300
            //   41b88d56e68c         | inc                 eax
            //   418bc0               | ror                 edx, cl
            //   f7e9                 | add                 edx, eax
            //   03d1                 | inc                 ecx

        $sequence_6 = { 458bc6 33d2 488bc8 e8???????? 4533c9 }
            // n = 5, score = 1300
            //   458bc6               | imul                ecx
            //   33d2                 | add                 edx, ecx
            //   488bc8               | sar                 edx, 0xb
            //   e8????????           |                     
            //   4533c9               | mov                 eax, edx

        $sequence_7 = { 410fbe00 49ffc0 d3ca 03d0 }
            // n = 4, score = 1300
            //   410fbe00             | inc                 ecx
            //   49ffc0               | movsx               eax, byte ptr [eax]
            //   d3ca                 | dec                 ecx
            //   03d0                 | inc                 eax

        $sequence_8 = { c1f906 6bd730 8b0c8d808e4100 c644112800 85f6 740c 56 }
            // n = 7, score = 200
            //   c1f906               | sar                 edx, 0xb
            //   6bd730               | mov                 eax, edx
            //   8b0c8d808e4100       | shr                 eax, 0x1f
            //   c644112800           | add                 edx, eax
            //   85f6                 | imul                eax, edx, 0xe89
            //   740c                 | dec                 esp
            //   56                   | mov                 eax, esi

        $sequence_9 = { 58 6bc000 c7803c88410002000000 6a04 58 6bc000 8b0d???????? }
            // n = 7, score = 200
            //   58                   | mov                 ecx, ebp
            //   6bc000               | xor                 edx, edx
            //   c7803c88410002000000     | inc    ecx
            //   6a04                 | movsx               eax, byte ptr [eax]
            //   58                   | dec                 ecx
            //   6bc000               | inc                 eax
            //   8b0d????????         |                     

        $sequence_10 = { 6a00 6a00 57 56 8945f8 ff15???????? }
            // n = 6, score = 200
            //   6a00                 | and                 dword ptr [esp + 0x20], esi
            //   6a00                 | mov                 eax, edx
            //   57                   | shr                 eax, 0x1f
            //   56                   | add                 edx, eax
            //   8945f8               | imul                eax, edx, 0xe89
            //   ff15????????         |                     

        $sequence_11 = { 41 4a c60100 b8???????? c745dc0c234100 8945bc }
            // n = 6, score = 200
            //   41                   | xor                 edx, edx
            //   4a                   | inc                 ecx
            //   c60100               | movsx               eax, byte ptr [eax]
            //   b8????????           |                     
            //   c745dc0c234100       | dec                 ecx
            //   8945bc               | inc                 eax

        $sequence_12 = { 8945e8 8945f8 8b4508 56 be???????? c745ec24234100 57 }
            // n = 7, score = 200
            //   8945e8               | mov                 eax, edx
            //   8945f8               | shr                 eax, 0x1f
            //   8b4508               | add                 edx, eax
            //   56                   | imul                eax, edx, 0xe89
            //   be????????           |                     
            //   c745ec24234100       | xor                 esi, esi
            //   57                   | lea                 ebp, [esi + 0x20]

        $sequence_13 = { 7420 6bc618 57 8db880904100 57 ff15???????? }
            // n = 6, score = 200
            //   7420                 | cmp                 ecx, eax
            //   6bc618               | dec                 eax
            //   57                   | sub                 esp, 0x28
            //   8db880904100         | dec                 eax
            //   57                   | test                ecx, ecx
            //   ff15????????         |                     

        $sequence_14 = { 83e03f 8bca 6bc030 c1f906 03048d808e4100 eb02 }
            // n = 6, score = 200
            //   83e03f               | ror                 edx, cl
            //   8bca                 | add                 edx, eax
            //   6bc030               | inc                 ecx
            //   c1f906               | sub                 edi, 1
            //   03048d808e4100       | imul                ecx
            //   eb02                 | add                 edx, ecx

        $sequence_15 = { 6bf030 03348d808e4100 837e18ff 740c }
            // n = 4, score = 200
            //   6bf030               | je                  7
            //   03348d808e4100       | call                ecx
            //   837e18ff             | mov                 eax, 1
            //   740c                 | sar                 edx, 0xb

    condition:
        7 of them and filesize < 286720
}