rule win_croxloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.croxloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.croxloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d4e18 41b801010000 e8???????? 418bc6 4d8d4d10 4c8d3d901d0100 }
            // n = 6, score = 100
            //   488d4e18             | je                  0x21b
            //   41b801010000         | inc                 esp
            //   e8????????           |                     
            //   418bc6               | mov                 eax, ebx
            //   4d8d4d10             | dec                 eax
            //   4c8d3d901d0100       | lea                 edx, [0x7e6d]

        $sequence_1 = { 4156 4157 488b05???????? 4d8bf8 448bf2 8bf1 4885c0 }
            // n = 7, score = 100
            //   4156                 | lea                 ecx, [eax + ecx*2]
            //   4157                 | xor                 ebx, ebx
            //   488b05????????       |                     
            //   4d8bf8               | dec                 eax
            //   448bf2               | lea                 ecx, [esp + 0x150]
            //   8bf1                 | dec                 eax
            //   4885c0               | mov                 dword ptr [esp + 0x30], ebx

        $sequence_2 = { 498bce ff15???????? 488bd8 eb02 33db 4c8d358d93ffff 4885db }
            // n = 7, score = 100
            //   498bce               | lea                 ecx, [0x11eb4]
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   eb02                 | lea                 eax, [0x11b66]
            //   33db                 | dec                 eax
            //   4c8d358d93ffff       | lea                 ecx, [0x11d8f]
            //   4885db               | jne                 0x98

        $sequence_3 = { 48c7c1ffffffff ff15???????? 488bbc2480030000 488b8c2460030000 }
            // n = 4, score = 100
            //   48c7c1ffffffff       | dec                 esp
            //   ff15????????         |                     
            //   488bbc2480030000     | mov                 edx, dword ptr [edi]
            //   488b8c2460030000     | dec                 ecx

        $sequence_4 = { 4c8d052aad0000 488bf9 488d1528ad0000 b904000000 e8???????? 8bd3 488bcf }
            // n = 7, score = 100
            //   4c8d052aad0000       | lea                 eax, [0x1213c]
            //   488bf9               | dec                 eax
            //   488d1528ad0000       | cmp                 dword ptr [ecx], eax
            //   b904000000           | cmp                 eax, 1
            //   e8????????           |                     
            //   8bd3                 | jne                 0x211
            //   488bcf               | dec                 eax

        $sequence_5 = { 4883ec20 448bf9 4c8d356e94ffff 4d8be1 }
            // n = 4, score = 100
            //   4883ec20             | inc                 esp
            //   448bf9               | mov                 byte ptr [esp + 0x70], dh
            //   4c8d356e94ffff       | jmp                 0xbe
            //   4d8be1               | dec                 eax

        $sequence_6 = { 48895c2408 57 4883ec20 488d1d5f290100 488d3d58290100 eb12 488b03 }
            // n = 7, score = 100
            //   48895c2408           | cmp                 edx, esi
            //   57                   | jl                  0x74
            //   4883ec20             | dec                 ebx
            //   488d1d5f290100       | mov                 ecx, dword ptr [eax + 0x19710]
            //   488d3d58290100       | inc                 ebx
            //   eb12                 | mov                 dword ptr [ebp - 0x65], ebx
            //   488b03               | inc                 edx

        $sequence_7 = { 33db 4c8d358d93ffff 4885db 750d }
            // n = 4, score = 100
            //   33db                 | dec                 ecx
            //   4c8d358d93ffff       | xor                 edi, edx
            //   4885db               | dec                 ebx
            //   750d                 | xchg                dword ptr [esi + edi*8 + 0x195f0], edi

        $sequence_8 = { 410f42d0 6bdb21 0fb6d2 03da 48ffc0 ebd6 8bc8 }
            // n = 7, score = 100
            //   410f42d0             | dec                 edx
            //   6bdb21               | mov                 eax, dword ptr [eax + ebp*8]
            //   0fb6d2               | inc                 edx
            //   03da                 | cmp                 byte ptr [eax + edi*8 + 0x38], bl
            //   48ffc0               | jge                 0xbc7
            //   ebd6                 | dec                 eax
            //   8bc8                 | mov                 ecx, dword ptr [eax + 0x90]

        $sequence_9 = { 803d????????00 754c 488d0db41e0100 48890d???????? 488d05661b0100 488d0d8f1d0100 488905???????? }
            // n = 7, score = 100
            //   803d????????00       |                     
            //   754c                 | dec                 eax
            //   488d0db41e0100       | lea                 eax, [0x166ca]
            //   48890d????????       |                     
            //   488d05661b0100       | dec                 eax
            //   488d0d8f1d0100       | cmp                 ebx, eax
            //   488905????????       |                     

    condition:
        7 of them and filesize < 241664
}