rule win_crutch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crutch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crutch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5608 50 52 e8???????? 50 68???????? 56 }
            // n = 7, score = 100
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   50                   | push                eax
            //   52                   | push                edx
            //   e8????????           |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_1 = { c7861840000001000000 e8???????? 83c40c eb55 8b8608400000 68???????? 68???????? }
            // n = 7, score = 100
            //   c7861840000001000000     | mov    dword ptr [esi + 0x4018], 1
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb55                 | jmp                 0x57
            //   8b8608400000         | mov                 eax, dword ptr [esi + 0x4008]
            //   68????????           |                     
            //   68????????           |                     

        $sequence_2 = { 771d 0fb68938370210 ff248d30370210 8b148500810610 52 68???????? eb19 }
            // n = 7, score = 100
            //   771d                 | ja                  0x1f
            //   0fb68938370210       | movzx               ecx, byte ptr [ecx + 0x10023738]
            //   ff248d30370210       | jmp                 dword ptr [ecx*4 + 0x10023730]
            //   8b148500810610       | mov                 edx, dword ptr [eax*4 + 0x10068100]
            //   52                   | push                edx
            //   68????????           |                     
            //   eb19                 | jmp                 0x1b

        $sequence_3 = { 762d 8b4c2444 390f 7560 8bd1 56 52 }
            // n = 7, score = 100
            //   762d                 | jbe                 0x2f
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]
            //   390f                 | cmp                 dword ptr [edi], ecx
            //   7560                 | jne                 0x62
            //   8bd1                 | mov                 edx, ecx
            //   56                   | push                esi
            //   52                   | push                edx

        $sequence_4 = { 51 e8???????? 83c404 85c0 740d c744245c2a000000 e9???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   c744245c2a000000     | mov                 dword ptr [esp + 0x5c], 0x2a
            //   e9????????           |                     

        $sequence_5 = { 33cc e8???????? 81c4a8090000 c3 663b742414 763a 8b4c2410 }
            // n = 7, score = 100
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     
            //   81c4a8090000         | add                 esp, 0x9a8
            //   c3                   | ret                 
            //   663b742414           | cmp                 si, word ptr [esp + 0x14]
            //   763a                 | jbe                 0x3c
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_6 = { 8b442428 8b742420 8b38 81c630050000 e8???????? 5f 5e }
            // n = 7, score = 100
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   81c630050000         | add                 esi, 0x530
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { ff7580 e8???????? 83c404 6a01 6a2f 53 e8???????? }
            // n = 7, score = 100
            //   ff7580               | push                dword ptr [ebp - 0x80]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6a01                 | push                1
            //   6a2f                 | push                0x2f
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_8 = { e9???????? 8b44240c 68???????? 50 e8???????? 83c408 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   e9????????           |                     

        $sequence_9 = { 52 e8???????? 8bf0 83c408 85f6 750f 5e }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   750f                 | jne                 0x11
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 1067008
}