rule win_crylocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crylocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crylocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d542408 68c5090000 52 e8???????? 8d442410 68???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d542408             | lea                 edx, [esp + 8]
            //   68c5090000           | push                0x9c5
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   68????????           |                     

        $sequence_1 = { ff15???????? 6afe e8???????? 83c404 5f 5e }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   6afe                 | push                -2
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 56 8da42400000000 8b44241c 8bf7 }
            // n = 4, score = 100
            //   56                   | push                esi
            //   8da42400000000       | lea                 esp, [esp]
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8bf7                 | mov                 esi, edi

        $sequence_3 = { 53 33ff ff15???????? 8bf0 3bf3 762e 3bfb }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   33ff                 | xor                 edi, edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   3bf3                 | cmp                 esi, ebx
            //   762e                 | jbe                 0x30
            //   3bfb                 | cmp                 edi, ebx

        $sequence_4 = { 8b7c242c 8b7704 50 e8???????? 8b4c2440 8bd8 51 }
            // n = 7, score = 100
            //   8b7c242c             | mov                 edi, dword ptr [esp + 0x2c]
            //   8b7704               | mov                 esi, dword ptr [edi + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   8bd8                 | mov                 ebx, eax
            //   51                   | push                ecx

        $sequence_5 = { 8d442430 50 e8???????? 8d4c2434 68???????? 51 e8???????? }
            // n = 7, score = 100
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_6 = { 50 50 8b44244c 50 6a00 6a00 56 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   50                   | push                eax
            //   8b44244c             | mov                 eax, dword ptr [esp + 0x4c]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_7 = { 50 894608 e8???????? 83c414 eb76 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb76                 | jmp                 0x78

        $sequence_8 = { 81c4cc000000 c3 5f 5e 5d b8fdffffff 5b }
            // n = 7, score = 100
            //   81c4cc000000         | add                 esp, 0xcc
            //   c3                   | ret                 
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b8fdffffff           | mov                 eax, 0xfffffffd
            //   5b                   | pop                 ebx

        $sequence_9 = { e8???????? 8d4c2408 6aff 51 e8???????? 8d542410 6a02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   6aff                 | push                -1
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   6a02                 | push                2

    condition:
        7 of them and filesize < 139264
}