rule win_crypto_fortress_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crypto_fortress."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crypto_fortress"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 045a aa 2cff aa 2cf9 }
            // n = 5, score = 100
            //   045a                 | add                 al, 0x5a
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2cff                 | sub                 al, 0xff
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2cf9                 | sub                 al, 0xf9

        $sequence_1 = { 0433 aa 04fc aa 3411 }
            // n = 5, score = 100
            //   0433                 | add                 al, 0x33
            //   aa                   | stosb               byte ptr es:[edi], al
            //   04fc                 | add                 al, 0xfc
            //   aa                   | stosb               byte ptr es:[edi], al
            //   3411                 | xor                 al, 0x11

        $sequence_2 = { aa 345e aa 04af aa 2cfb aa }
            // n = 7, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   345e                 | xor                 al, 0x5e
            //   aa                   | stosb               byte ptr es:[edi], al
            //   04af                 | add                 al, 0xaf
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2cfb                 | sub                 al, 0xfb
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_3 = { aa 040f aa 2c0f }
            // n = 4, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   040f                 | add                 al, 0xf
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2c0f                 | sub                 al, 0xf

        $sequence_4 = { aa 341b aa 2c01 }
            // n = 4, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   341b                 | xor                 al, 0x1b
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2c01                 | sub                 al, 1

        $sequence_5 = { 894304 83c308 8345fc08 c78548ffffff9c000000 }
            // n = 4, score = 100
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   83c308               | add                 ebx, 8
            //   8345fc08             | add                 dword ptr [ebp - 4], 8
            //   c78548ffffff9c000000     | mov    dword ptr [ebp - 0xb8], 0x9c

        $sequence_6 = { 2c00 aa 0411 aa 2c51 aa 3421 }
            // n = 7, score = 100
            //   2c00                 | sub                 al, 0
            //   aa                   | stosb               byte ptr es:[edi], al
            //   0411                 | add                 al, 0x11
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2c51                 | sub                 al, 0x51
            //   aa                   | stosb               byte ptr es:[edi], al
            //   3421                 | xor                 al, 0x21

        $sequence_7 = { 2cee aa 2c01 aa 04f1 }
            // n = 5, score = 100
            //   2cee                 | sub                 al, 0xee
            //   aa                   | stosb               byte ptr es:[edi], al
            //   2c01                 | sub                 al, 1
            //   aa                   | stosb               byte ptr es:[edi], al
            //   04f1                 | add                 al, 0xf1

        $sequence_8 = { 85c0 0f84d0000000 68???????? 8d85eafeffff 50 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f84d0000000         | je                  0xd6
            //   68????????           |                     
            //   8d85eafeffff         | lea                 eax, [ebp - 0x116]
            //   50                   | push                eax

        $sequence_9 = { 8bec 83c4f8 53 ff35???????? e8???????? 6bc004 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83c4f8               | add                 esp, -8
            //   53                   | push                ebx
            //   ff35????????         |                     
            //   e8????????           |                     
            //   6bc004               | imul                eax, eax, 4

    condition:
        7 of them and filesize < 188416
}