rule win_cryptolocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptolocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptolocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e810 50 8b4610 52 ffd0 0fb6c0 5e }
            // n = 7, score = 600
            //   c1e810               | shr                 eax, 0x10
            //   50                   | push                eax
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   52                   | push                edx
            //   ffd0                 | call                eax
            //   0fb6c0               | movzx               eax, al
            //   5e                   | pop                 esi

        $sequence_1 = { 83f80d 7605 663bc3 7504 }
            // n = 4, score = 600
            //   83f80d               | cmp                 eax, 0xd
            //   7605                 | jbe                 7
            //   663bc3               | cmp                 ax, bx
            //   7504                 | jne                 6

        $sequence_2 = { 8b06 8945e0 8b4604 8945e4 8b4d14 }
            // n = 5, score = 600
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]

        $sequence_3 = { 7539 ff7508 8b55ec 8b4de8 e8???????? }
            // n = 5, score = 600
            //   7539                 | jne                 0x3b
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_4 = { 48 7527 33f6 397714 7620 8b1d???????? 8b4710 }
            // n = 7, score = 600
            //   48                   | dec                 eax
            //   7527                 | jne                 0x29
            //   33f6                 | xor                 esi, esi
            //   397714               | cmp                 dword ptr [edi + 0x14], esi
            //   7620                 | jbe                 0x22
            //   8b1d????????         |                     
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]

        $sequence_5 = { 5d c21800 8b4304 6a40 ff7518 8b4004 }
            // n = 6, score = 600
            //   5d                   | pop                 ebp
            //   c21800               | ret                 0x18
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   6a40                 | push                0x40
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_6 = { ff15???????? 668b45dc 66a3???????? 8be5 5d c3 33c0 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   668b45dc             | mov                 ax, word ptr [ebp - 0x24]
            //   66a3????????         |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 4e 49 79e4 5b }
            // n = 4, score = 600
            //   4e                   | dec                 esi
            //   49                   | dec                 ecx
            //   79e4                 | jns                 0xffffffe6
            //   5b                   | pop                 ebx

        $sequence_8 = { 740e 50 52 ff35???????? ff15???????? 5f }
            // n = 6, score = 600
            //   740e                 | je                  0x10
            //   50                   | push                eax
            //   52                   | push                edx
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   5f                   | pop                 edi

        $sequence_9 = { 8bd8 81fb7a000780 750e 807dff00 751f }
            // n = 5, score = 600
            //   8bd8                 | mov                 ebx, eax
            //   81fb7a000780         | cmp                 ebx, 0x8007007a
            //   750e                 | jne                 0x10
            //   807dff00             | cmp                 byte ptr [ebp - 1], 0
            //   751f                 | jne                 0x21

    condition:
        7 of them and filesize < 778240
}