rule win_cryptoluck_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptoluck."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptoluck"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837d1000 7409 c745d880720010 eb07 c745d878720010 837d1000 7409 }
            // n = 7, score = 100
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7409                 | je                  0xb
            //   c745d880720010       | mov                 dword ptr [ebp - 0x28], 0x10007280
            //   eb07                 | jmp                 9
            //   c745d878720010       | mov                 dword ptr [ebp - 0x28], 0x10007278
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7409                 | je                  0xb

        $sequence_1 = { 83c40c 8945f4 6a00 6880000000 6a02 6a00 6a01 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_2 = { 83ec20 8d45f8 50 8b4d08 51 ff15???????? 8b55fc }
            // n = 7, score = 100
            //   83ec20               | sub                 esp, 0x20
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_3 = { 51 837d1801 730f 8b4514 50 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   837d1801             | cmp                 dword ptr [ebp + 0x18], 1
            //   730f                 | jae                 0x11
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   50                   | push                eax

        $sequence_4 = { 52 ff15???????? 898504f0ffff 680f040000 8b8504f0ffff 8d8c05e8fbffff }
            // n = 6, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   898504f0ffff         | mov                 dword ptr [ebp - 0xffc], eax
            //   680f040000           | push                0x40f
            //   8b8504f0ffff         | mov                 eax, dword ptr [ebp - 0xffc]
            //   8d8c05e8fbffff       | lea                 ecx, [ebp + eax - 0x418]

        $sequence_5 = { 8b4508 69c0100e0000 99 03c8 13f2 894de8 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   69c0100e0000         | imul                eax, eax, 0xe10
            //   99                   | cdq                 
            //   03c8                 | add                 ecx, eax
            //   13f2                 | adc                 esi, edx
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx

        $sequence_6 = { f610 57 4c 2434 cd40 0234d2 2d734ce893 }
            // n = 7, score = 100
            //   f610                 | not                 byte ptr [eax]
            //   57                   | push                edi
            //   4c                   | dec                 esp
            //   2434                 | and                 al, 0x34
            //   cd40                 | int                 0x40
            //   0234d2               | add                 dh, byte ptr [edx + edx*8]
            //   2d734ce893           | sub                 eax, 0x93e84c73

        $sequence_7 = { 8b45c8 83c001 8945c8 8b4dc0 83e901 894dc0 ebe0 }
            // n = 7, score = 100
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   83c001               | add                 eax, 1
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   83e901               | sub                 ecx, 1
            //   894dc0               | mov                 dword ptr [ebp - 0x40], ecx
            //   ebe0                 | jmp                 0xffffffe2

        $sequence_8 = { 8b4de8 51 8b55fc 2b55f4 52 8b45f8 }
            // n = 6, score = 100
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   51                   | push                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   2b55f4               | sub                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_9 = { ff15???????? 898540ffffff 83bd40ffffff00 7472 8b8d40ffffff 51 8b55e0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   898540ffffff         | mov                 dword ptr [ebp - 0xc0], eax
            //   83bd40ffffff00       | cmp                 dword ptr [ebp - 0xc0], 0
            //   7472                 | je                  0x74
            //   8b8d40ffffff         | mov                 ecx, dword ptr [ebp - 0xc0]
            //   51                   | push                ecx
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]

    condition:
        7 of them and filesize < 229376
}