rule win_cryptoshuffler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptoshuffler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptoshuffler"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 660f282d???????? 660f59f5 660f28aa20a50210 660f54e5 660f58fe }
            // n = 5, score = 100
            //   660f282d????????     |                     
            //   660f59f5             | mulpd               xmm6, xmm5
            //   660f28aa20a50210     | movapd              xmm5, xmmword ptr [edx + 0x1002a520]
            //   660f54e5             | andpd               xmm4, xmm5
            //   660f58fe             | addpd               xmm7, xmm6

        $sequence_1 = { 8d0486 894304 5f 8933 }
            // n = 4, score = 100
            //   8d0486               | lea                 eax, [esi + eax*4]
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   5f                   | pop                 edi
            //   8933                 | mov                 dword ptr [ebx], esi

        $sequence_2 = { f6c11f 0f85ad040000 8b41fc 3bc1 0f83a2040000 }
            // n = 5, score = 100
            //   f6c11f               | test                cl, 0x1f
            //   0f85ad040000         | jne                 0x4b3
            //   8b41fc               | mov                 eax, dword ptr [ecx - 4]
            //   3bc1                 | cmp                 eax, ecx
            //   0f83a2040000         | jae                 0x4a8

        $sequence_3 = { 83f85b 757d 8b06 8b4e08 3bc1 }
            // n = 5, score = 100
            //   83f85b               | cmp                 eax, 0x5b
            //   757d                 | jne                 0x7f
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   3bc1                 | cmp                 eax, ecx

        $sequence_4 = { 837e4c29 8ad8 0f85fd000000 8b06 8b4e08 3bc1 }
            // n = 6, score = 100
            //   837e4c29             | cmp                 dword ptr [esi + 0x4c], 0x29
            //   8ad8                 | mov                 bl, al
            //   0f85fd000000         | jne                 0x103
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   3bc1                 | cmp                 eax, ecx

        $sequence_5 = { c7401c00000000 c7402000000000 8906 894604 8b4508 89460c 8bc6 }
            // n = 7, score = 100
            //   c7401c00000000       | mov                 dword ptr [eax + 0x1c], 0
            //   c7402000000000       | mov                 dword ptr [eax + 0x20], 0
            //   8906                 | mov                 dword ptr [esi], eax
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { 8b4508 83c020 50 ff15???????? 5d c3 6a0a }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c020               | add                 eax, 0x20
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a0a                 | push                0xa

        $sequence_7 = { e8???????? 8bce e8???????? 837e4cff b101 0f8555fcffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   837e4cff             | cmp                 dword ptr [esi + 0x4c], -1
            //   b101                 | mov                 cl, 1
            //   0f8555fcffff         | jne                 0xfffffc5b

        $sequence_8 = { 8d45b4 89458c 8d458c 51 50 51 e8???????? }
            // n = 7, score = 100
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   89458c               | mov                 dword ptr [ebp - 0x74], eax
            //   8d458c               | lea                 eax, [ebp - 0x74]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_9 = { 6685c0 0f84e7000000 6a00 8d4e24 }
            // n = 4, score = 100
            //   6685c0               | test                ax, ax
            //   0f84e7000000         | je                  0xed
            //   6a00                 | push                0
            //   8d4e24               | lea                 ecx, [esi + 0x24]

    condition:
        7 of them and filesize < 425984
}