rule win_cuegoe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cuegoe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cuegoe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8985500c0000 8b432c 8b4b24 57 }
            // n = 4, score = 200
            //   8985500c0000         | mov                 dword ptr [ebp + 0xc50], eax
            //   8b432c               | mov                 eax, dword ptr [ebx + 0x2c]
            //   8b4b24               | mov                 ecx, dword ptr [ebx + 0x24]
            //   57                   | push                edi

        $sequence_1 = { 57 8db55c030000 e8???????? 53 57 8db59c030000 e8???????? }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8db55c030000         | lea                 esi, [ebp + 0x35c]
            //   e8????????           |                     
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8db59c030000         | lea                 esi, [ebp + 0x39c]
            //   e8????????           |                     

        $sequence_2 = { 8bff 8b4500 83780400 0f84961a0000 8b30 0fb636 8b551c }
            // n = 7, score = 200
            //   8bff                 | mov                 edi, edi
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   83780400             | cmp                 dword ptr [eax + 4], 0
            //   0f84961a0000         | je                  0x1a9c
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   0fb636               | movzx               esi, byte ptr [esi]
            //   8b551c               | mov                 edx, dword ptr [ebp + 0x1c]

        $sequence_3 = { 894740 8b454c 894744 8b4550 894748 8b4554 89474c }
            // n = 7, score = 200
            //   894740               | mov                 dword ptr [edi + 0x40], eax
            //   8b454c               | mov                 eax, dword ptr [ebp + 0x4c]
            //   894744               | mov                 dword ptr [edi + 0x44], eax
            //   8b4550               | mov                 eax, dword ptr [ebp + 0x50]
            //   894748               | mov                 dword ptr [edi + 0x48], eax
            //   8b4554               | mov                 eax, dword ptr [ebp + 0x54]
            //   89474c               | mov                 dword ptr [edi + 0x4c], eax

        $sequence_4 = { 0f8554020000 57 83ec18 8bc4 89654c 53 50 }
            // n = 7, score = 200
            //   0f8554020000         | jne                 0x25a
            //   57                   | push                edi
            //   83ec18               | sub                 esp, 0x18
            //   8bc4                 | mov                 eax, esp
            //   89654c               | mov                 dword ptr [ebp + 0x4c], esp
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_5 = { 8b149580cf0310 c1e006 8d440224 802080 884dfd 8065fd48 884dff }
            // n = 7, score = 200
            //   8b149580cf0310       | mov                 edx, dword ptr [edx*4 + 0x1003cf80]
            //   c1e006               | shl                 eax, 6
            //   8d440224             | lea                 eax, [edx + eax + 0x24]
            //   802080               | and                 byte ptr [eax], 0x80
            //   884dfd               | mov                 byte ptr [ebp - 3], cl
            //   8065fd48             | and                 byte ptr [ebp - 3], 0x48
            //   884dff               | mov                 byte ptr [ebp - 1], cl

        $sequence_6 = { 894310 5e 5f c20400 6a04 }
            // n = 5, score = 200
            //   894310               | mov                 dword ptr [ebx + 0x10], eax
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c20400               | ret                 4
            //   6a04                 | push                4

        $sequence_7 = { b8???????? e8???????? 8b7508 8365f000 c706???????? c746581c520310 }
            // n = 6, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0
            //   c706????????         |                     
            //   c746581c520310       | mov                 dword ptr [esi + 0x58], 0x1003521c

        $sequence_8 = { ff5004 0fb7c0 6a01 50 ff7528 8d758c ff7524 }
            // n = 7, score = 200
            //   ff5004               | call                dword ptr [eax + 4]
            //   0fb7c0               | movzx               eax, ax
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff7528               | push                dword ptr [ebp + 0x28]
            //   8d758c               | lea                 esi, [ebp - 0x74]
            //   ff7524               | push                dword ptr [ebp + 0x24]

        $sequence_9 = { 897dc4 50 c745fc02000000 e8???????? 33c0 c745c401000000 c745ec07000000 }
            // n = 7, score = 200
            //   897dc4               | mov                 dword ptr [ebp - 0x3c], edi
            //   50                   | push                eax
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c745c401000000       | mov                 dword ptr [ebp - 0x3c], 1
            //   c745ec07000000       | mov                 dword ptr [ebp - 0x14], 7

    condition:
        7 of them and filesize < 540672
}