rule win_cueisfry_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cueisfry."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cueisfry"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 8d8c24b8050000 68???????? 51 }
            // n = 5, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   8d8c24b8050000       | lea                 ecx, [esp + 0x5b8]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_1 = { 7517 8d8c24b0010000 68???????? 51 e8???????? }
            // n = 5, score = 100
            //   7517                 | jne                 0x19
            //   8d8c24b0010000       | lea                 ecx, [esp + 0x1b0]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_2 = { c3 81ec24030000 a1???????? 8b0d???????? }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   81ec24030000         | sub                 esp, 0x324
            //   a1????????           |                     
            //   8b0d????????         |                     

        $sequence_3 = { 8dbc2435010000 c684243401000000 68???????? f3ab 66ab 8d8c2438010000 51 }
            // n = 7, score = 100
            //   8dbc2435010000       | lea                 edi, [esp + 0x135]
            //   c684243401000000     | mov                 byte ptr [esp + 0x134], 0
            //   68????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d8c2438010000       | lea                 ecx, [esp + 0x138]
            //   51                   | push                ecx

        $sequence_4 = { 8bee 33ff 85c9 89542430 896c2410 0f8ebd010000 8d4103 }
            // n = 7, score = 100
            //   8bee                 | mov                 ebp, esi
            //   33ff                 | xor                 edi, edi
            //   85c9                 | test                ecx, ecx
            //   89542430             | mov                 dword ptr [esp + 0x30], edx
            //   896c2410             | mov                 dword ptr [esp + 0x10], ebp
            //   0f8ebd010000         | jle                 0x1c3
            //   8d4103               | lea                 eax, [ecx + 3]

        $sequence_5 = { b940000000 33c0 8dbc2435010000 c684243401000000 }
            // n = 4, score = 100
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8dbc2435010000       | lea                 edi, [esp + 0x135]
            //   c684243401000000     | mov                 byte ptr [esp + 0x134], 0

        $sequence_6 = { 6aff 68???????? 64a100000000 50 64892500000000 81eca8070000 }
            // n = 6, score = 100
            //   6aff                 | push                -1
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   81eca8070000         | sub                 esp, 0x7a8

        $sequence_7 = { 68???????? f3a5 50 e8???????? 8d4c2424 }
            // n = 5, score = 100
            //   68????????           |                     
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_8 = { 68???????? 50 c744242401000000 c744242000010000 }
            // n = 4, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   c744242401000000     | mov                 dword ptr [esp + 0x24], 1
            //   c744242000010000     | mov                 dword ptr [esp + 0x20], 0x100

        $sequence_9 = { 51 8d442420 8bcc 89642430 50 c68424c401000003 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   8bcc                 | mov                 ecx, esp
            //   89642430             | mov                 dword ptr [esp + 0x30], esp
            //   50                   | push                eax
            //   c68424c401000003     | mov                 byte ptr [esp + 0x1c4], 3

    condition:
        7 of them and filesize < 81920
}