rule win_curator_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.curator."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.curator"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d4108 4889459f 488d5d8f 4883fa10 480f435d8f 4803d9 41b808000000 }
            // n = 7, score = 200
            //   488d4108             | test                eax, eax
            //   4889459f             | je                  0xc0a
            //   488d5d8f             | inc                 ebp
            //   4883fa10             | xor                 eax, eax
            //   480f435d8f           | xor                 edx, edx
            //   4803d9               | dec                 eax
            //   41b808000000         | lea                 edx, [0x2de71]

        $sequence_1 = { 488b07 488d542420 488bcf ff9090000000 488bcd 48c1e903 488b4620 }
            // n = 7, score = 200
            //   488b07               | lea                 edx, [esp + 0x70]
            //   488d542420           | dec                 eax
            //   488bcf               | cmp                 ecx, edx
            //   ff9090000000         | setne               dl
            //   488bcd               | call                dword ptr [eax + 0x20]
            //   48c1e903             | dec                 eax
            //   488b4620             | and                 dword ptr [ebp - 0x58], 0

        $sequence_2 = { 85c0 0f4ed0 e8???????? 488d15c2140400 488d4c2420 e8???????? cc }
            // n = 7, score = 200
            //   85c0                 | dec                 eax
            //   0f4ed0               | mov                 dword ptr [ebp - 0x40], eax
            //   e8????????           |                     
            //   488d15c2140400       | movaps              xmm0, xmmword ptr [ebp - 0x40]
            //   488d4c2420           | jmp                 0x758
            //   e8????????           |                     
            //   cc                   | cmp                 eax, 1

        $sequence_3 = { 5d c3 4883c202 488915???????? 0fbe0a 85c9 74bd }
            // n = 7, score = 200
            //   5d                   | je                  0x303
            //   c3                   | dec                 ecx
            //   4883c202             | cmp                 eax, 0x20
            //   488915????????       |                     
            //   0fbe0a               | jb                  0x2d9
            //   85c9                 | dec                 ebp
            //   74bd                 | mov                 ecx, eax

        $sequence_4 = { 8b45d8 e9???????? 0fbe42ff 488d4dd0 83c004 4863d0 488d05abbf0300 }
            // n = 7, score = 200
            //   8b45d8               | add                 ecx, 0x18
            //   e9????????           |                     
            //   0fbe42ff             | dec                 eax
            //   488d4dd0             | and                 dword ptr [ecx], 0
            //   83c004               | dec                 eax
            //   4863d0               | mov                 edx, dword ptr [edx + 0x18]
            //   488d05abbf0300       | mov                 al, byte ptr [edx + 0x11]

        $sequence_5 = { 83e802 0f853ffaffff 660f6fa42400010000 660ffe2424 660f6fac24d0010000 660ffeac24d0000000 660f6fb424a0010000 }
            // n = 7, score = 200
            //   83e802               | dec                 eax
            //   0f853ffaffff         | mov                 eax, dword ptr [ebx + 8]
            //   660f6fa42400010000     | and    dword ptr [esp + 0x28], 0
            //   660ffe2424           | dec                 eax
            //   660f6fac24d0010000     | lea    eax, [0xfffebf1c]
            //   660ffeac24d0000000     | dec    eax
            //   660f6fb424a0010000     | mov    dword ptr [esp + 0x30], eax

        $sequence_6 = { 4156 4157 4883ec50 488b7128 4c8d25880c0000 33ed 488bf9 }
            // n = 7, score = 200
            //   4156                 | dec                 eax
            //   4157                 | lea                 ecx, [0xe8a5]
            //   4883ec50             | xorps               xmm0, xmm0
            //   488b7128             | dec                 eax
            //   4c8d25880c0000       | mov                 dword ptr [ebx], ecx
            //   33ed                 | inc                 eax
            //   488bf9               | push                ebx

        $sequence_7 = { 488945e0 895128 488d0d332f0300 488b45d8 488908 488d0d950a0500 488b45d8 }
            // n = 7, score = 200
            //   488945e0             | mov                 eax, ebx
            //   895128               | dec                 eax
            //   488d0d332f0300       | mov                 ebx, dword ptr [esp + 0x60]
            //   488b45d8             | dec                 eax
            //   488908               | mov                 dword ptr [ebx], ecx
            //   488d0d950a0500       | jmp                 0x2b7
            //   488b45d8             | dec                 eax

        $sequence_8 = { 0fb68c2490000000 4c8d0501350300 4803da 4883f101 4803d9 482bfb 488bcb }
            // n = 7, score = 200
            //   0fb68c2490000000     | dec                 eax
            //   4c8d0501350300       | lea                 edx, [ebx + 8]
            //   4803da               | dec                 eax
            //   4883f101             | lea                 ecx, [eax + 8]
            //   4803d9               | movups              xmmword ptr [edx], xmm0
            //   482bfb               | dec                 eax
            //   488bcb               | lea                 eax, [0x2f74c]

        $sequence_9 = { ff15???????? 4885c0 7411 488bc8 ff15???????? 3bc6 0f84eb040000 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   7411                 | lea                 ebx, [ecx - 0x10]
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   3bc6                 | add                 ebx, dword ptr [ebp + 0x5f]
            //   0f84eb040000         | dec                 eax

    condition:
        7 of them and filesize < 1265664
}