rule win_curlback_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.curlback."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.curlback"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 84c0 7420 488d153ac20c00 488bcb e8???????? eb0f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | mov                 ecx, eax
            //   7420                 | dec                 eax
            //   488d153ac20c00       | lea                 edx, [0x146a9]
            //   488bcb               | mov                 edx, dword ptr [ebx + 0xc70]
            //   e8????????           |                     
            //   eb0f                 | cmp                 edx, dword ptr [ebx + 0xc68]

        $sequence_1 = { ba15000000 488bce e8???????? eb4c 488b5318 488bc8 e8???????? }
            // n = 7, score = 100
            //   ba15000000           | dec                 eax
            //   488bce               | lea                 ecx, [ebp - 0x70]
            //   e8????????           |                     
            //   eb4c                 | nop                 
            //   488b5318             | nop                 
            //   488bc8               | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 8bd8 85c0 752e 488b97a8080000 488d8f08130000 e8???????? 8bd8 }
            // n = 7, score = 100
            //   8bd8                 | cmovl               eax, ebp
            //   85c0                 | mov                 eax, dword ptr [edi + 0x228]
            //   752e                 | mov                 dword ptr [edi + 0xd20], eax
            //   488b97a8080000       | dec                 esp
            //   488d8f08130000       | mov                 dword ptr [esp + 0x30], esi
            //   e8????????           |                     
            //   8bd8                 | dec                 eax

        $sequence_3 = { 85c0 7848 488b4550 488b08 488b5958 498bd6 488d8d88000000 }
            // n = 7, score = 100
            //   85c0                 | mov                 ecx, esi
            //   7848                 | jmp                 0x23f
            //   488b4550             | test                eax, eax
            //   488b08               | jne                 0x219
            //   488b5958             | jmp                 0x212
            //   498bd6               | mov                 byte ptr [ebp + 0x80], 1
            //   488d8d88000000       | mov                 byte ptr [esi + 0x3c5], 1

        $sequence_4 = { 7527 488b4c2460 4c8bc5 e8???????? 85c0 7516 488d15ac050b00 }
            // n = 7, score = 100
            //   7527                 | mov                 byte ptr [esp], ch
            //   488b4c2460           | mov                 esi, 0x38
            //   4c8bc5               | dec                 esp
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, ebp
            //   7516                 | jne                 0xec7
            //   488d15ac050b00       | dec                 eax

        $sequence_5 = { 4883c908 498bc7 48894c2470 0fb6d1 48894590 eb14 b8f7ffffff }
            // n = 7, score = 100
            //   4883c908             | mov                 eax, ecx
            //   498bc7               | dec                 eax
            //   48894c2470           | mov                 ecx, ebx
            //   0fb6d1               | dec                 eax
            //   48894590             | cmp                 dword ptr [ecx + 0x18], 0xf
            //   eb14                 | jbe                 0x1704
            //   b8f7ffffff           | dec                 eax

        $sequence_6 = { baffff0000 e8???????? 48899ec8010000 33c0 8983ac1c0000 488bce }
            // n = 6, score = 100
            //   baffff0000           | mov                 ecx, ebx
            //   e8????????           |                     
            //   48899ec8010000       | dec                 eax
            //   33c0                 | lea                 edx, [esp + 0x68]
            //   8983ac1c0000         | dec                 eax
            //   488bce               | mov                 ecx, ebx

        $sequence_7 = { e8???????? 894340 83f80d 742a 83f80b 0f8562050000 498bce }
            // n = 7, score = 100
            //   e8????????           |                     
            //   894340               | inc                 esp
            //   83f80d               | mov                 byte ptr [esp + 0x78], ah
            //   742a                 | dec                 eax
            //   83f80b               | lea                 ecx, [ebp - 0x28]
            //   0f8562050000         | nop                 
            //   498bce               | dec                 esp

        $sequence_8 = { eb11 488b4308 488b08 48894ddf eb04 4c897def 48895db7 }
            // n = 7, score = 100
            //   eb11                 | movzx               edx, bp
            //   488b4308             | call                dword ptr [eax + 0x18]
            //   488b08               | movzx               ebp, ax
            //   48894ddf             | inc                 ecx
            //   eb04                 | mov                 edi, 0xffff
            //   4c897def             | inc                 sp
            //   48895db7             | cmp                 edi, ebp

        $sequence_9 = { 80bd2d13000000 7513 488bcd 85db 0f84a1000000 488bd3 e8???????? }
            // n = 7, score = 100
            //   80bd2d13000000       | mov                 ebx, edx
            //   7513                 | dec                 eax
            //   488bcd               | mov                 edi, ecx
            //   85db                 | je                  0x4c0
            //   0f84a1000000         | dec                 esp
            //   488bd3               | mov                 ecx, dword ptr [ecx + 0x12a0]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 4027392
}