rule win_dadstache_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dadstache."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dadstache"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b35???????? 85c9 7403 51 ffd6 a1???????? }
            // n = 6, score = 500
            //   8b35????????         |                     
            //   85c9                 | test                ecx, ecx
            //   7403                 | je                  5
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   a1????????           |                     

        $sequence_1 = { 6a40 6a00 8d4620 c70600000000 c7460400000000 c7460800000000 }
            // n = 6, score = 500
            //   6a40                 | push                0x40
            //   6a00                 | push                0
            //   8d4620               | lea                 eax, [esi + 0x20]
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c7460400000000       | mov                 dword ptr [esi + 4], 0
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0

        $sequence_2 = { 57 6aff 6a00 8d4508 c74424240f000000 }
            // n = 5, score = 500
            //   57                   | push                edi
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   8d4508               | lea                 eax, [ebp + 8]
            //   c74424240f000000     | mov                 dword ptr [esp + 0x24], 0xf

        $sequence_3 = { 756c ff15???????? 53 53 8d4d08 }
            // n = 5, score = 500
            //   756c                 | jne                 0x6e
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d4d08               | lea                 ecx, [ebp + 8]

        $sequence_4 = { 83c404 85c0 7428 8bb30c020000 8bf8 }
            // n = 5, score = 500
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7428                 | je                  0x2a
            //   8bb30c020000         | mov                 esi, dword ptr [ebx + 0x20c]
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { 57 8d4304 c6437401 50 53 c7070c000000 c7431400000000 }
            // n = 7, score = 500
            //   57                   | push                edi
            //   8d4304               | lea                 eax, [ebx + 4]
            //   c6437401             | mov                 byte ptr [ebx + 0x74], 1
            //   50                   | push                eax
            //   53                   | push                ebx
            //   c7070c000000         | mov                 dword ptr [edi], 0xc
            //   c7431400000000       | mov                 dword ptr [ebx + 0x14], 0

        $sequence_6 = { 314608 8b470c 8bf9 31460c 0f1006 }
            // n = 5, score = 500
            //   314608               | xor                 dword ptr [esi + 8], eax
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   8bf9                 | mov                 edi, ecx
            //   31460c               | xor                 dword ptr [esi + 0xc], eax
            //   0f1006               | movups              xmm0, xmmword ptr [esi]

        $sequence_7 = { 8b45f4 c1e808 0fb6c0 894e04 8bcb c1e918 }
            // n = 6, score = 500
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c1e808               | shr                 eax, 8
            //   0fb6c0               | movzx               eax, al
            //   894e04               | mov                 dword ptr [esi + 4], ecx
            //   8bcb                 | mov                 ecx, ebx
            //   c1e918               | shr                 ecx, 0x18

        $sequence_8 = { 8b4604 8d7604 85c0 75ee b801000000 }
            // n = 5, score = 200
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8d7604               | lea                 esi, [esi + 4]
            //   85c0                 | test                eax, eax
            //   75ee                 | jne                 0xfffffff0
            //   b801000000           | mov                 eax, 1

        $sequence_9 = { 57 03c3 895508 33ff 8945fc }
            // n = 5, score = 200
            //   57                   | push                edi
            //   03c3                 | add                 eax, ebx
            //   895508               | mov                 dword ptr [ebp + 8], edx
            //   33ff                 | xor                 edi, edi
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_10 = { 8b55f4 8b4485b0 85d2 8b56f8 7405 0d00020000 }
            // n = 6, score = 200
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b4485b0             | mov                 eax, dword ptr [ebp + eax*4 - 0x50]
            //   85d2                 | test                edx, edx
            //   8b56f8               | mov                 edx, dword ptr [esi - 8]
            //   7405                 | je                  7
            //   0d00020000           | or                  eax, 0x200

        $sequence_11 = { 8b06 85c0 7543 8b46f8 8945ec }
            // n = 5, score = 200
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   7543                 | jne                 0x45
            //   8b46f8               | mov                 eax, dword ptr [esi - 8]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_12 = { 8955e0 0f2805???????? 8b703c 03f0 b801000000 }
            // n = 5, score = 200
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   0f2805????????       |                     
            //   8b703c               | mov                 esi, dword ptr [eax + 0x3c]
            //   03f0                 | add                 esi, eax
            //   b801000000           | mov                 eax, 1

        $sequence_13 = { c745bc56697274 50 57 c745c075616c41 }
            // n = 4, score = 200
            //   c745bc56697274       | mov                 dword ptr [ebp - 0x44], 0x74726956
            //   50                   | push                eax
            //   57                   | push                edi
            //   c745c075616c41       | mov                 dword ptr [ebp - 0x40], 0x416c6175

        $sequence_14 = { 51 ff55f4 8bf8 85ff 0f8423ffffff }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   ff55f4               | call                dword ptr [ebp - 0xc]
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f8423ffffff         | je                  0xffffff29

        $sequence_15 = { 56 ff7034 ffd7 8945f8 85c0 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   ff7034               | push                dword ptr [eax + 0x34]
            //   ffd7                 | call                edi
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 580608
}