rule win_dairy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dairy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dairy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8bf2 57 81e607000080 7905 4e }
            // n = 6, score = 100
            //   56                   | push                esi
            //   8bf2                 | mov                 esi, edx
            //   57                   | push                edi
            //   81e607000080         | and                 esi, 0x80000007
            //   7905                 | jns                 7
            //   4e                   | dec                 esi

        $sequence_1 = { 8d542410 8d442414 52 68ff030000 50 }
            // n = 5, score = 100
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   52                   | push                edx
            //   68ff030000           | push                0x3ff
            //   50                   | push                eax

        $sequence_2 = { 8bd1 83c9ff 50 f2ae 8bca }
            // n = 5, score = 100
            //   8bd1                 | mov                 edx, ecx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   50                   | push                eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8bca                 | mov                 ecx, edx

        $sequence_3 = { 8b44241c 57 8b3e ba2037efc6 8b08 8b4004 897c2418 }
            // n = 7, score = 100
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   57                   | push                edi
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   ba2037efc6           | mov                 edx, 0xc6ef3720
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi

        $sequence_4 = { aa e8???????? 83c40c 83f8ff 0f8514ffffff e9???????? 6a10 }
            // n = 7, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83f8ff               | cmp                 eax, -1
            //   0f8514ffffff         | jne                 0xffffff1a
            //   e9????????           |                     
            //   6a10                 | push                0x10

        $sequence_5 = { 7f3b ba27000000 2bd1 bf???????? 83c9ff }
            // n = 5, score = 100
            //   7f3b                 | jg                  0x3d
            //   ba27000000           | mov                 edx, 0x27
            //   2bd1                 | sub                 edx, ecx
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_6 = { f2ae f7d1 2bf9 8d5c241c 8bf7 8be9 8bfb }
            // n = 7, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d5c241c             | lea                 ebx, [esp + 0x1c]
            //   8bf7                 | mov                 esi, edi
            //   8be9                 | mov                 ebp, ecx
            //   8bfb                 | mov                 edi, ebx

        $sequence_7 = { c70701000000 e8???????? 83c404 894704 b801000000 5f 5e }
            // n = 7, score = 100
            //   c70701000000         | mov                 dword ptr [edi], 1
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { f3a4 75cc 8d7c243c 83c9ff }
            // n = 4, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   75cc                 | jne                 0xffffffce
            //   8d7c243c             | lea                 edi, [esp + 0x3c]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_9 = { 52 68???????? 50 e8???????? 83c410 85c0 7542 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7542                 | jne                 0x44

    condition:
        7 of them and filesize < 212992
}