rule win_danbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.danbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.danbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8965f0 4c896df8 448865e0 488d5580 488d4d00 e8???????? }
            // n = 6, score = 200
            //   4c8965f0             | mov                 dword ptr [ebp + 0x18], 7
            //   4c896df8             | mov                 word ptr [ebp], bx
            //   448865e0             | xor                 ebx, ebx
            //   488d5580             | mov                 dword ptr [esp + 0x20], ebx
            //   488d4d00             | xor                 edx, edx
            //   e8????????           |                     

        $sequence_1 = { 4585c0 0f840e020000 89bb88000000 4183f803 0f82b6000000 8b8394000000 85c0 }
            // n = 7, score = 200
            //   4585c0               | lea                 eax, [0x1e7bf]
            //   0f840e020000         | dec                 eax
            //   89bb88000000         | lea                 edx, [0x1e7c0]
            //   4183f803             | dec                 eax
            //   0f82b6000000         | lea                 edx, [0x7f19f]
            //   8b8394000000         | dec                 eax
            //   85c0                 | lea                 ecx, [esp + 0x118]

        $sequence_2 = { 55 56 57 4881ec90000000 48c7442420feffffff 49895b18 488b05???????? }
            // n = 7, score = 200
            //   55                   | dec                 eax
            //   56                   | mov                 edi, eax
            //   57                   | dec                 eax
            //   4881ec90000000       | test                eax, eax
            //   48c7442420feffffff     | mov    ecx, 1
            //   49895b18             | dec                 esp
            //   488b05????????       |                     

        $sequence_3 = { 483bd7 720e 48ffc2 4d8bc6 498b0f e8???????? }
            // n = 6, score = 200
            //   483bd7               | movzx               ecx, byte ptr [eax + esi + 0x38]
            //   720e                 | dec                 esp
            //   48ffc2               | lea                 ebp, [0x44886]
            //   4d8bc6               | and                 esi, 0x3f
            //   498b0f               | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 488bda 33c0 488b5110 4983c8ff 89442420 48894310 48c743180f000000 }
            // n = 7, score = 200
            //   488bda               | mov                 edx, eax
            //   33c0                 | dec                 eax
            //   488b5110             | lea                 ecx, [esp + 0x620]
            //   4983c8ff             | nop                 
            //   89442420             | dec                 esp
            //   48894310             | lea                 eax, [0x971d9]
            //   48c743180f000000     | dec                 esp

        $sequence_5 = { ffd3 99 33c2 2bc2 89442430 448be0 4c89642450 }
            // n = 7, score = 200
            //   ffd3                 | sub                 edx, esi
            //   99                   | inc                 esp
            //   33c2                 | mov                 dword ptr [ebx + 0x18], esp
            //   2bc2                 | jmp                 0x1ad6
            //   89442430             | mov                 dword ptr [ebx + 0x5c], 2
            //   448be0               | dec                 ecx
            //   4c89642450           | add                 edi, edi

        $sequence_6 = { eb03 488bd9 8b4018 25c0010000 410f100424 beffff0000 83f840 }
            // n = 7, score = 200
            //   eb03                 | dec                 eax
            //   488bd9               | mov                 dword ptr [esp + 0x28], esi
            //   8b4018               | dec                 eax
            //   25c0010000           | lea                 eax, [esp + 0x44]
            //   410f100424           | dec                 eax
            //   beffff0000           | mov                 dword ptr [esp + 0x20], eax
            //   83f840               | inc                 ebp

        $sequence_7 = { 488bce ffd3 90 488b742478 488b06 488b5838 488bcb }
            // n = 7, score = 200
            //   488bce               | mov                 ebx, eax
            //   ffd3                 | dec                 esp
            //   90                   | mov                 edx, dword ptr [ebp + 0x4f8]
            //   488b742478           | dec                 eax
            //   488b06               | lea                 eax, [0x33c44]
            //   488b5838             | movups              xmm0, xmmword ptr [eax]
            //   488bcb               | dec                 esp

        $sequence_8 = { 48897310 4c897318 408833 0f1007 0f1103 0f104f10 0f114b10 }
            // n = 7, score = 200
            //   48897310             | test                ecx, ecx
            //   4c897318             | je                  0x2fd
            //   408833               | cmp                 word ptr [eax], 0xa
            //   0f1007               | dec                 eax
            //   0f1103               | shr                 edx, 1
            //   0f104f10             | dec                 eax
            //   0f114b10             | sub                 eax, edx

        $sequence_9 = { 498bcd e8???????? 4533d2 84c0 741d 418adc 488bcf }
            // n = 7, score = 200
            //   498bcd               | je                  0x1714
            //   e8????????           |                     
            //   4533d2               | dec                 ecx
            //   84c0                 | mov                 edx, edi
            //   741d                 | dec                 eax
            //   418adc               | lea                 ecx, [esp + 0x240]
            //   488bcf               | dec                 eax

    condition:
        7 of them and filesize < 1492992
}