rule win_darkcloud_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkcloud."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkcloud"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 68???????? 8d857cffffff 50 ff15???????? 8d8d7cffffff 51 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8d7cffffff         | lea                 ecx, [ebp - 0x84]
            //   51                   | push                ecx

        $sequence_1 = { 8b9584feffff 52 8b8580feffff 50 ff15???????? 898568fdffff eb0a }
            // n = 7, score = 100
            //   8b9584feffff         | mov                 edx, dword ptr [ebp - 0x17c]
            //   52                   | push                edx
            //   8b8580feffff         | mov                 eax, dword ptr [ebp - 0x180]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   898568fdffff         | mov                 dword ptr [ebp - 0x298], eax
            //   eb0a                 | jmp                 0xc

        $sequence_2 = { 89952cffffff 6aff 8b45a8 50 8b4d08 8b11 52 }
            // n = 7, score = 100
            //   89952cffffff         | mov                 dword ptr [ebp - 0xd4], edx
            //   6aff                 | push                -1
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   52                   | push                edx

        $sequence_3 = { c7458c0a000000 c745a404000280 c7459c0a000000 c745b404000280 c745ac0a000000 8b45d8 }
            // n = 6, score = 100
            //   c7458c0a000000       | mov                 dword ptr [ebp - 0x74], 0xa
            //   c745a404000280       | mov                 dword ptr [ebp - 0x5c], 0x80020004
            //   c7459c0a000000       | mov                 dword ptr [ebp - 0x64], 0xa
            //   c745b404000280       | mov                 dword ptr [ebp - 0x4c], 0x80020004
            //   c745ac0a000000       | mov                 dword ptr [ebp - 0x54], 0xa
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_4 = { 83c418 c745fc11000000 ba???????? 8d4da0 ff15???????? 8d45a0 50 }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   c745fc11000000       | mov                 dword ptr [ebp - 4], 0x11
            //   ba????????           |                     
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   ff15????????         |                     
            //   8d45a0               | lea                 eax, [ebp - 0x60]
            //   50                   | push                eax

        $sequence_5 = { 51 8d8544ffffff 52 50 ff15???????? }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8d8544ffffff         | lea                 eax, [ebp - 0xbc]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { 8bd0 8d4d98 ff15???????? ba???????? 8d4dac ff15???????? 8b5598 }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   ff15????????         |                     
            //   ba????????           |                     
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   ff15????????         |                     
            //   8b5598               | mov                 edx, dword ptr [ebp - 0x68]

        $sequence_7 = { ff15???????? 8d4dc8 ff15???????? 8d4db8 ff15???????? c745fc0c000000 8b45d4 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   ff15????????         |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   ff15????????         |                     
            //   c745fc0c000000       | mov                 dword ptr [ebp - 4], 0xc
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]

        $sequence_8 = { 68???????? ff15???????? 8bd0 8d4da8 ff15???????? 8d4590 50 }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   ff15????????         |                     
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax

        $sequence_9 = { 8d4d88 51 8d558c 52 8d4590 50 6a05 }
            // n = 7, score = 100
            //   8d4d88               | lea                 ecx, [ebp - 0x78]
            //   51                   | push                ecx
            //   8d558c               | lea                 edx, [ebp - 0x74]
            //   52                   | push                edx
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax
            //   6a05                 | push                5

    condition:
        7 of them and filesize < 622592
}