rule win_darkme_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkme."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkme"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40 f7d8 668985f0feffff 8d4d84 ff15???????? 8d8d70ffffff ff15???????? }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   f7d8                 | neg                 eax
            //   668985f0feffff       | mov                 word ptr [ebp - 0x110], ax
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]
            //   ff15????????         |                     
            //   8d8d70ffffff         | lea                 ecx, [ebp - 0x90]
            //   ff15????????         |                     

        $sequence_1 = { eb12 8b95ecfeffff 81c2???????? 8995a8feffff 8b85a8feffff 8b08 8b95a8feffff }
            // n = 7, score = 100
            //   eb12                 | jmp                 0x14
            //   8b95ecfeffff         | mov                 edx, dword ptr [ebp - 0x114]
            //   81c2????????         |                     
            //   8995a8feffff         | mov                 dword ptr [ebp - 0x158], edx
            //   8b85a8feffff         | mov                 eax, dword ptr [ebp - 0x158]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b95a8feffff         | mov                 edx, dword ptr [ebp - 0x158]

        $sequence_2 = { 8d4ddc 898d90feffff 8b9590feffff 8b02 8985e4feffff 6a00 8b4dc8 }
            // n = 7, score = 100
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   898d90feffff         | mov                 dword ptr [ebp - 0x170], ecx
            //   8b9590feffff         | mov                 edx, dword ptr [ebp - 0x170]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8985e4feffff         | mov                 dword ptr [ebp - 0x11c], eax
            //   6a00                 | push                0
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]

        $sequence_3 = { 8b8504ffffff 8b08 8b01 52 ff9098030000 50 }
            // n = 6, score = 100
            //   8b8504ffffff         | mov                 eax, dword ptr [ebp - 0xfc]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   52                   | push                edx
            //   ff9098030000         | call                dword ptr [eax + 0x398]
            //   50                   | push                eax

        $sequence_4 = { c745f8???????? c745fc00000000 8b7508 8b06 56 ff5004 668b4d0c }
            // n = 7, score = 100
            //   c745f8????????       |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   56                   | push                esi
            //   ff5004               | call                dword ptr [eax + 4]
            //   668b4d0c             | mov                 cx, word ptr [ebp + 0xc]

        $sequence_5 = { 7459 c745fc08000000 6a10 8b55cc 52 8d45d0 50 }
            // n = 7, score = 100
            //   7459                 | je                  0x5b
            //   c745fc08000000       | mov                 dword ptr [ebp - 4], 8
            //   6a10                 | push                0x10
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   52                   | push                edx
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax

        $sequence_6 = { c745b801000000 c745b002000000 8b55d4 52 8d45b0 50 d9856cffffff }
            // n = 7, score = 100
            //   c745b801000000       | mov                 dword ptr [ebp - 0x48], 1
            //   c745b002000000       | mov                 dword ptr [ebp - 0x50], 2
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   52                   | push                edx
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax
            //   d9856cffffff         | fld                 dword ptr [ebp - 0x94]

        $sequence_7 = { 898d24ffffff eb12 8b9530ffffff 81c2???????? 899524ffffff 8b8524ffffff 8b08 }
            // n = 7, score = 100
            //   898d24ffffff         | mov                 dword ptr [ebp - 0xdc], ecx
            //   eb12                 | jmp                 0x14
            //   8b9530ffffff         | mov                 edx, dword ptr [ebp - 0xd0]
            //   81c2????????         |                     
            //   899524ffffff         | mov                 dword ptr [ebp - 0xdc], edx
            //   8b8524ffffff         | mov                 eax, dword ptr [ebp - 0xdc]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_8 = { 8b1491 52 68???????? e8???????? 8bd0 8d4dac ff15???????? }
            // n = 7, score = 100
            //   8b1491               | mov                 edx, dword ptr [ecx + edx*4]
            //   52                   | push                edx
            //   68????????           |                     
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   ff15????????         |                     

        $sequence_9 = { 6a00 6a00 6a01 6a08 8b9530ffffff 81c2???????? 52 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a08                 | push                8
            //   8b9530ffffff         | mov                 edx, dword ptr [ebp - 0xd0]
            //   81c2????????         |                     
            //   52                   | push                edx

    condition:
        7 of them and filesize < 1515520
}