rule win_darkmegi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkmegi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkmegi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 6804010000 50 56 ff15???????? 8d8c2488090000 }
            // n = 6, score = 100
            //   33f6                 | xor                 esi, esi
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d8c2488090000       | lea                 ecx, [esp + 0x988]

        $sequence_1 = { 3bd9 7cd2 8806 5f 5e 5d 5b }
            // n = 7, score = 100
            //   3bd9                 | cmp                 ebx, ecx
            //   7cd2                 | jl                  0xffffffd4
            //   8806                 | mov                 byte ptr [esi], al
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_2 = { 57 8b7c2414 57 e8???????? 8b542414 83c404 8d4c2408 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   8d4c2408             | lea                 ecx, [esp + 8]

        $sequence_3 = { 8d0440 8b8c8420010000 c6040a00 8b442410 }
            // n = 4, score = 100
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   8b8c8420010000       | mov                 ecx, dword ptr [esp + eax*4 + 0x120]
            //   c6040a00             | mov                 byte ptr [edx + ecx], 0
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_4 = { f2ae 8bcd 4f c1e902 f3a5 8b842464020000 }
            // n = 6, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8bcd                 | mov                 ecx, ebp
            //   4f                   | dec                 edi
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b842464020000       | mov                 eax, dword ptr [esp + 0x264]

        $sequence_5 = { 85c0 0f849f000000 8dbc246c020000 83c9ff 33c0 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f849f000000         | je                  0xa5
            //   8dbc246c020000       | lea                 edi, [esp + 0x26c]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8d04c0 8b0c8d40a7b402 f644810401 8d0481 7403 8b00 }
            // n = 6, score = 100
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   8b0c8d40a7b402       | mov                 ecx, dword ptr [ecx*4 + 0x2b4a740]
            //   f644810401           | test                byte ptr [ecx + eax*4 + 4], 1
            //   8d0481               | lea                 eax, [ecx + eax*4]
            //   7403                 | je                  5
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_7 = { 5d 5b c3 8b542414 5f 5e 5d }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_8 = { 8bac24a8020000 53 66ab aa }
            // n = 4, score = 100
            //   8bac24a8020000       | mov                 ebp, dword ptr [esp + 0x2a8]
            //   53                   | push                ebx
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_9 = { 3bf8 0f8d43010000 8d4c2414 8d942498030000 51 }
            // n = 5, score = 100
            //   3bf8                 | cmp                 edi, eax
            //   0f8d43010000         | jge                 0x149
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   8d942498030000       | lea                 edx, [esp + 0x398]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 90304
}