rule win_darkmoon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkmoon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkmoon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 898580f0ffff ff750c 680f0d0000 ffb580f0ffff 56 ff96d1000000 e8???????? }
            // n = 7, score = 100
            //   898580f0ffff         | mov                 dword ptr [ebp - 0xf80], eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   680f0d0000           | push                0xd0f
            //   ffb580f0ffff         | push                dword ptr [ebp - 0xf80]
            //   56                   | push                esi
            //   ff96d1000000         | call                dword ptr [esi + 0xd1]
            //   e8????????           |                     

        $sequence_1 = { ff75f0 ff5675 83f800 766d 6a00 8d4df8 }
            // n = 6, score = 100
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff5675               | call                dword ptr [esi + 0x75]
            //   83f800               | cmp                 eax, 0
            //   766d                 | jbe                 0x6f
            //   6a00                 | push                0
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_2 = { 8d4f0c c645fc05 e8???????? 8d4f10 c645fc06 e8???????? }
            // n = 6, score = 100
            //   8d4f0c               | lea                 ecx, [edi + 0xc]
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e8????????           |                     
            //   8d4f10               | lea                 ecx, [edi + 0x10]
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   e8????????           |                     

        $sequence_3 = { 68ff0f1f00 ff9695000000 83f800 74ac }
            // n = 4, score = 100
            //   68ff0f1f00           | push                0x1f0fff
            //   ff9695000000         | call                dword ptr [esi + 0x95]
            //   83f800               | cmp                 eax, 0
            //   74ac                 | je                  0xffffffae

        $sequence_4 = { 8d8656040000 50 6801000080 ff5635 8d8665010000 50 }
            // n = 6, score = 100
            //   8d8656040000         | lea                 eax, [esi + 0x456]
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   ff5635               | call                dword ptr [esi + 0x35]
            //   8d8665010000         | lea                 eax, [esi + 0x165]
            //   50                   | push                eax

        $sequence_5 = { 3b86b0080000 747c 8986b0080000 6804010000 8d85fcfdffff }
            // n = 5, score = 100
            //   3b86b0080000         | cmp                 eax, dword ptr [esi + 0x8b0]
            //   747c                 | je                  0x7e
            //   8986b0080000         | mov                 dword ptr [esi + 0x8b0], eax
            //   6804010000           | push                0x104
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]

        $sequence_6 = { 6a01 6a00 e8???????? 53 4f 46 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   e8????????           |                     
            //   53                   | push                ebx
            //   4f                   | dec                 edi
            //   46                   | inc                 esi

        $sequence_7 = { ff5621 8945f4 6a00 8d4df8 }
            // n = 4, score = 100
            //   ff5621               | call                dword ptr [esi + 0x21]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   6a00                 | push                0
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_8 = { ffb6e1000000 ff96dd000000 8945f4 6a00 ff75f8 ffb6ed000000 6a00 }
            // n = 7, score = 100
            //   ffb6e1000000         | push                dword ptr [esi + 0xe1]
            //   ff96dd000000         | call                dword ptr [esi + 0xdd]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   6a00                 | push                0
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ffb6ed000000         | push                dword ptr [esi + 0xed]
            //   6a00                 | push                0

        $sequence_9 = { 03d0 8b442410 03c2 89442410 8bc6 99 f7f9 }
            // n = 7, score = 100
            //   03d0                 | add                 edx, eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   03c2                 | add                 eax, edx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8bc6                 | mov                 eax, esi
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx

    condition:
        7 of them and filesize < 98304
}