rule win_darkrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c408 837b100a 8b7dd4 0f8514ffffff 8b55ec }
            // n = 5, score = 200
            //   83c408               | add                 esp, 8
            //   837b100a             | cmp                 dword ptr [ebx + 0x10], 0xa
            //   8b7dd4               | mov                 edi, dword ptr [ebp - 0x2c]
            //   0f8514ffffff         | jne                 0xffffff1a
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_1 = { e8???????? 83c408 c745e800000000 8d4dd8 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]

        $sequence_2 = { 51 56 e8???????? 83c40c c6043e00 eb17 57 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c6043e00             | mov                 byte ptr [esi + edi], 0
            //   eb17                 | jmp                 0x19
            //   57                   | push                edi

        $sequence_3 = { 72bd 8b4d08 42 8bc1 81fa00100000 72a5 8b49fc }
            // n = 7, score = 200
            //   72bd                 | jb                  0xffffffbf
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   42                   | inc                 edx
            //   8bc1                 | mov                 eax, ecx
            //   81fa00100000         | cmp                 edx, 0x1000
            //   72a5                 | jb                  0xffffffa7
            //   8b49fc               | mov                 ecx, dword ptr [ecx - 4]

        $sequence_4 = { 7435 6a13 68???????? 8bcb }
            // n = 4, score = 200
            //   7435                 | je                  0x37
            //   6a13                 | push                0x13
            //   68????????           |                     
            //   8bcb                 | mov                 ecx, ebx

        $sequence_5 = { 85c0 7527 6a0c 68???????? 8bcb e8???????? }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7527                 | jne                 0x29
            //   6a0c                 | push                0xc
            //   68????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_6 = { c645fc01 8b45cc 83f810 7227 8d4801 }
            // n = 5, score = 200
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   83f810               | cmp                 eax, 0x10
            //   7227                 | jb                  0x29
            //   8d4801               | lea                 ecx, [eax + 1]

        $sequence_7 = { c7856cffffff0f000000 c68558ffffff00 6880000000 8d8570ffffff c745fc01000000 }
            // n = 5, score = 200
            //   c7856cffffff0f000000     | mov    dword ptr [ebp - 0x94], 0xf
            //   c68558ffffff00       | mov                 byte ptr [ebp - 0xa8], 0
            //   6880000000           | push                0x80
            //   8d8570ffffff         | lea                 eax, [ebp - 0x90]
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_8 = { c745d400000000 e8???????? 50 e8???????? 83c408 c745e800000000 8d4dd8 }
            // n = 7, score = 200
            //   c745d400000000       | mov                 dword ptr [ebp - 0x2c], 0
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]

        $sequence_9 = { 8b4314 0f43d6 8b7b10 2bc7 8b4dc8 3bc8 7726 }
            // n = 7, score = 200
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   0f43d6               | cmovae              edx, esi
            //   8b7b10               | mov                 edi, dword ptr [ebx + 0x10]
            //   2bc7                 | sub                 eax, edi
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   3bc8                 | cmp                 ecx, eax
            //   7726                 | ja                  0x28

    condition:
        7 of them and filesize < 884736
}