rule win_darkshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkshell"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c004 8901 83c014 8902 6681380b01 7511 }
            // n = 6, score = 300
            //   83c004               | add                 eax, 4
            //   8901                 | mov                 dword ptr [ecx], eax
            //   83c014               | add                 eax, 0x14
            //   8902                 | mov                 dword ptr [edx], eax
            //   6681380b01           | cmp                 word ptr [eax], 0x10b
            //   7511                 | jne                 0x13

        $sequence_1 = { 8b442434 83c410 8b8088000000 85c0 }
            // n = 4, score = 300
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   83c410               | add                 esp, 0x10
            //   8b8088000000         | mov                 eax, dword ptr [eax + 0x88]
            //   85c0                 | test                eax, eax

        $sequence_2 = { c744246044000000 ff15???????? 8be8 85ed 0f8494000000 8bbc2488000000 }
            // n = 6, score = 300
            //   c744246044000000     | mov                 dword ptr [esp + 0x60], 0x44
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   85ed                 | test                ebp, ebp
            //   0f8494000000         | je                  0x9a
            //   8bbc2488000000       | mov                 edi, dword ptr [esp + 0x88]

        $sequence_3 = { 51 50 8b442420 50 ff15???????? }
            // n = 5, score = 300
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 8d7e08 f7c2feffffff 767a 668b07 8bc8 81e100f00000 6681f90030 }
            // n = 7, score = 300
            //   8d7e08               | lea                 edi, [esi + 8]
            //   f7c2feffffff         | test                edx, 0xfffffffe
            //   767a                 | jbe                 0x7c
            //   668b07               | mov                 ax, word ptr [edi]
            //   8bc8                 | mov                 ecx, eax
            //   81e100f00000         | and                 ecx, 0xf000
            //   6681f90030           | cmp                 cx, 0x3000

        $sequence_5 = { ffd6 5e c20400 8b15???????? }
            // n = 4, score = 300
            //   ffd6                 | call                esi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   8b15????????         |                     

        $sequence_6 = { 8b35???????? 48 7457 48 742b }
            // n = 5, score = 300
            //   8b35????????         |                     
            //   48                   | dec                 eax
            //   7457                 | je                  0x59
            //   48                   | dec                 eax
            //   742b                 | je                  0x2d

        $sequence_7 = { f3ab 66ab aa 8b442410 83c9ff 8b5008 33c0 }
            // n = 7, score = 300
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 5e c20400 8b15???????? 68???????? 52 }
            // n = 5, score = 300
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   8b15????????         |                     
            //   68????????           |                     
            //   52                   | push                edx

        $sequence_9 = { 03ca c1e80c 51 50 68???????? }
            // n = 5, score = 300
            //   03ca                 | add                 ecx, edx
            //   c1e80c               | shr                 eax, 0xc
            //   51                   | push                ecx
            //   50                   | push                eax
            //   68????????           |                     

    condition:
        7 of them and filesize < 344064
}