rule win_darkside_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkside."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkside"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 5b 5d c20800 55 8bec 53 }
            // n = 7, score = 1100
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx

        $sequence_1 = { 895c0e04 893c0e 81ea10101010 2d10101010 81eb10101010 81ef10101010 }
            // n = 6, score = 1100
            //   895c0e04             | mov                 dword ptr [esi + ecx + 4], ebx
            //   893c0e               | mov                 dword ptr [esi + ecx], edi
            //   81ea10101010         | sub                 edx, 0x10101010
            //   2d10101010           | sub                 eax, 0x10101010
            //   81eb10101010         | sub                 ebx, 0x10101010
            //   81ef10101010         | sub                 edi, 0x10101010

        $sequence_2 = { 75d2 5f 5e 5a 59 }
            // n = 5, score = 1100
            //   75d2                 | jne                 0xffffffd4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_3 = { 8b4508 8b10 8b5804 8b7808 8b400c 89540e0c 89440e08 }
            // n = 7, score = 1100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b5804               | mov                 ebx, dword ptr [eax + 4]
            //   8b7808               | mov                 edi, dword ptr [eax + 8]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   89540e0c             | mov                 dword ptr [esi + ecx + 0xc], edx
            //   89440e08             | mov                 dword ptr [esi + ecx + 8], eax

        $sequence_4 = { be???????? 8b4508 8b10 8b5804 8b7808 8b400c }
            // n = 6, score = 1100
            //   be????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b5804               | mov                 ebx, dword ptr [eax + 4]
            //   8b7808               | mov                 edi, dword ptr [eax + 8]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]

        $sequence_5 = { b9f0000000 be???????? 8b4508 8b10 }
            // n = 4, score = 1100
            //   b9f0000000           | mov                 ecx, 0xf0
            //   be????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_6 = { e8???????? 5f 5e 5a 59 5b 5d }
            // n = 7, score = 1100
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp

        $sequence_7 = { 85c0 7418 8bd8 68ff000000 57 }
            // n = 5, score = 1100
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8bd8                 | mov                 ebx, eax
            //   68ff000000           | push                0xff
            //   57                   | push                edi

        $sequence_8 = { 57 e8???????? 81c7ff000000 4b 85db 75ea }
            // n = 6, score = 1100
            //   57                   | push                edi
            //   e8????????           |                     
            //   81c7ff000000         | add                 edi, 0xff
            //   4b                   | dec                 ebx
            //   85db                 | test                ebx, ebx
            //   75ea                 | jne                 0xffffffec

        $sequence_9 = { 75da eb06 33db fec1 75d2 5f 5e }
            // n = 7, score = 1100
            //   75da                 | jne                 0xffffffdc
            //   eb06                 | jmp                 8
            //   33db                 | xor                 ebx, ebx
            //   fec1                 | inc                 cl
            //   75d2                 | jne                 0xffffffd4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 286720
}