rule win_darktequila_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darktequila."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darktequila"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 894604 8bc6 5e c3 8bff }
            // n = 6, score = 200
            //   a1????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi

        $sequence_1 = { 33c5 8945fc 33c0 53 8bd9 33c9 }
            // n = 6, score = 200
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   33c0                 | xor                 eax, eax
            //   53                   | push                ebx
            //   8bd9                 | mov                 ebx, ecx
            //   33c9                 | xor                 ecx, ecx

        $sequence_2 = { 83c00d b901000000 ba???????? e8???????? }
            // n = 4, score = 200
            //   83c00d               | add                 eax, 0xd
            //   b901000000           | mov                 ecx, 1
            //   ba????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 894df8 e8???????? 83c410 8bf3 e8???????? }
            // n = 5, score = 200
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8bf3                 | mov                 esi, ebx
            //   e8????????           |                     

        $sequence_4 = { 40 83f838 72dc b8???????? c3 33d2 3915???????? }
            // n = 7, score = 200
            //   40                   | inc                 eax
            //   83f838               | cmp                 eax, 0x38
            //   72dc                 | jb                  0xffffffde
            //   b8????????           |                     
            //   c3                   | ret                 
            //   33d2                 | xor                 edx, edx
            //   3915????????         |                     

        $sequence_5 = { 83f818 72dc b8???????? c3 }
            // n = 4, score = 200
            //   83f818               | cmp                 eax, 0x18
            //   72dc                 | jb                  0xffffffde
            //   b8????????           |                     
            //   c3                   | ret                 

        $sequence_6 = { 85c0 7466 8b4b0c 8b5310 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   7466                 | je                  0x68
            //   8b4b0c               | mov                 ecx, dword ptr [ebx + 0xc]
            //   8b5310               | mov                 edx, dword ptr [ebx + 0x10]

        $sequence_7 = { 884ddf 8945e0 8945e4 8945e8 8945ec }
            // n = 5, score = 200
            //   884ddf               | mov                 byte ptr [ebp - 0x21], cl
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_8 = { 4a 7419 83ea02 753c 8b4508 }
            // n = 5, score = 200
            //   4a                   | dec                 edx
            //   7419                 | je                  0x1b
            //   83ea02               | sub                 edx, 2
            //   753c                 | jne                 0x3e
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_9 = { e8???????? 85c0 742e a1???????? 8d5001 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   742e                 | je                  0x30
            //   a1????????           |                     
            //   8d5001               | lea                 edx, [eax + 1]

    condition:
        7 of them and filesize < 1827840
}