rule win_darkvision_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkvision_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkvision_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0a 8b44243c ffc0 8944243c 837c243c64 }
            // n = 5, score = 100
            //   eb0a                 | dec                 eax
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x1c0]
            //   ffc0                 | dec                 eax
            //   8944243c             | add                 eax, 0x208
            //   837c243c64           | dec                 eax

        $sequence_1 = { 85c0 7523 488d15da6b0300 488b8c2460030000 ff15???????? 488b8c2460030000 ff15???????? }
            // n = 7, score = 100
            //   85c0                 | mov                 eax, dword ptr [esp + 0x70]
            //   7523                 | dec                 eax
            //   488d15da6b0300       | shl                 eax, 3
            //   488b8c2460030000     | dec                 eax
            //   ff15????????         |                     
            //   488b8c2460030000     | mov                 dword ptr [esp + 0x38], eax
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? 488b8c2468030000 ff15???????? 41b838000000 33d2 488d8c2428030000 e8???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b8c2468030000     | lea                 eax, [esp + 0xe0]
            //   ff15????????         |                     
            //   41b838000000         | dec                 eax
            //   33d2                 | mov                 dword ptr [esp + 0x30], eax
            //   488d8c2428030000     | mov                 dword ptr [esp + 0x28], 4
            //   e8????????           |                     

        $sequence_3 = { 488d0d9efe0100 48837c010800 7432 4863442424 4869c0040b0000 488d0d83fe0100 66ba6600 }
            // n = 7, score = 100
            //   488d0d9efe0100       | mov                 eax, dword ptr [esp + 0xe4]
            //   48837c010800         | dec                 eax
            //   7432                 | shl                 eax, 1
            //   4863442424           | dec                 eax
            //   4869c0040b0000       | lea                 ecx, [esp + 0xa8]
            //   488d0d83fe0100       | dec                 eax
            //   66ba6600             | mov                 dword ptr [esp + 0x30], ecx

        $sequence_4 = { 741d 488b4c2438 ff15???????? 488b4c2430 ff15???????? 33c0 }
            // n = 6, score = 100
            //   741d                 | je                  0x15bc
            //   488b4c2438           | mov                 edx, 0x7fff
            //   ff15????????         |                     
            //   488b4c2430           | dec                 eax
            //   ff15????????         |                     
            //   33c0                 | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_5 = { 4c8d0505910100 baff7f0000 488b4c2440 ff15???????? 4c8d0deaf40200 4c8d05ff900100 baff7f0000 }
            // n = 7, score = 100
            //   4c8d0505910100       | mov                 ecx, dword ptr [esp + 0xc]
            //   baff7f0000           | xor                 ecx, eax
            //   488b4c2440           | mov                 eax, ecx
            //   ff15????????         |                     
            //   4c8d0deaf40200       | mov                 dword ptr [esp + 0xc], eax
            //   4c8d05ff900100       | shr                 ecx, 0x13
            //   baff7f0000           | or                  eax, ecx

        $sequence_6 = { baffffffff 488b4c0110 ff15???????? 4863442424 486bc028 488d0d71550200 48837c010800 }
            // n = 7, score = 100
            //   baffffffff           | dec                 eax
            //   488b4c0110           | mov                 ecx, dword ptr [esp + 0xe0]
            //   ff15????????         |                     
            //   4863442424           | dec                 eax
            //   486bc028             | and                 ecx, eax
            //   488d0d71550200       | shl                 ecx, 0x18
            //   48837c010800         | or                  eax, ecx

        $sequence_7 = { ff15???????? 4885c0 0f847a010000 488bc8 ff15???????? 488d15e0620000 488bce }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   0f847a010000         | add                 ecx, eax
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d15e0620000       | mov                 eax, ecx
            //   488bce               | dec                 eax

        $sequence_8 = { 488b4c2430 4803c8 488bc1 4889442470 c744247c00000000 eb0a }
            // n = 6, score = 100
            //   488b4c2430           | dec                 eax
            //   4803c8               | mov                 eax, dword ptr [esp + 0x28]
            //   488bc1               | dec                 eax
            //   4889442470           | mov                 ecx, dword ptr [esp + 0x50]
            //   c744247c00000000     | movzx               ecx, byte ptr [ecx]
            //   eb0a                 | mov                 byte ptr [eax], cl

        $sequence_9 = { ba7c040000 b940000000 ff15???????? 4889442428 48837c242800 0f8477020000 4c8b442428 }
            // n = 7, score = 100
            //   ba7c040000           | shl                 ecx, 0x18
            //   b940000000           | or                  eax, ecx
            //   ff15????????         |                     
            //   4889442428           | mov                 dword ptr [esp + 0x9c], eax
            //   48837c242800         | dec                 eax
            //   0f8477020000         | mov                 eax, dword ptr [esp + 0xd8]
            //   4c8b442428           | movzx               eax, byte ptr [eax + 0x14]

    condition:
        7 of them and filesize < 618496
}