rule win_daxin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.daxin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.daxin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bc2 d1f8 99 f7f9 }
            // n = 4, score = 400
            //   2bc2                 | sub                 eax, edx
            //   d1f8                 | sar                 eax, 1
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx

        $sequence_1 = { 418b5b3c 418b6b38 e8???????? 85db }
            // n = 4, score = 300
            //   418b5b3c             | and                 ecx, edi
            //   418b6b38             | inc                 ebp
            //   e8????????           |                     
            //   85db                 | xor                 eax, eax

        $sequence_2 = { 0fb7c0 0bc8 2b8bd0000000 85c9 0f8eec000000 }
            // n = 5, score = 300
            //   0fb7c0               | xor                 eax, eax
            //   0bc8                 | mov                 byte ptr [edi + 8], al
            //   2b8bd0000000         | movzx               eax, ax
            //   85c9                 | or                  ecx, eax
            //   0f8eec000000         | sub                 ecx, dword ptr [ebx + 0xd0]

        $sequence_3 = { 488bf0 4885c0 0f8467ffffff 33d2 41b8e0000000 }
            // n = 5, score = 300
            //   488bf0               | test                ecx, ecx
            //   4885c0               | jle                 0xf4
            //   0f8467ffffff         | dec                 eax
            //   33d2                 | mov                 esi, eax
            //   41b8e0000000         | dec                 eax

        $sequence_4 = { 66f7d8 1bc0 f7d8 83c003 eb15 }
            // n = 5, score = 300
            //   66f7d8               | neg                 ax
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   83c003               | add                 eax, 3
            //   eb15                 | jmp                 0x17

        $sequence_5 = { 4533c0 498bcb e8???????? 668bd8 6641895b0a }
            // n = 5, score = 300
            //   4533c0               | mov                 eax, 0xe0
            //   498bcb               | je                  0xc
            //   e8????????           |                     
            //   668bd8               | mov                 eax, dword ptr [edx]
            //   6641895b0a           | and                 eax, ecx

        $sequence_6 = { 740a 8b02 23c1 23cf }
            // n = 4, score = 300
            //   740a                 | test                eax, eax
            //   8b02                 | je                  0xffffff70
            //   23c1                 | xor                 edx, edx
            //   23cf                 | inc                 ecx

        $sequence_7 = { 0f8cd8000000 ff15???????? 4c8b4f28 4533c0 884708 }
            // n = 5, score = 300
            //   0f8cd8000000         | jl                  0xde
            //   ff15????????         |                     
            //   4c8b4f28             | dec                 esp
            //   4533c0               | mov                 ecx, dword ptr [edi + 0x28]
            //   884708               | inc                 ebp

        $sequence_8 = { b930000000 33c0 8bfd 66c74664ffff }
            // n = 4, score = 100
            //   b930000000           | idiv                ecx
            //   33c0                 | or                  eax, ecx
            //   8bfd                 | lea                 eax, [eax + eax*2]
            //   66c74664ffff         | shl                 eax, 3

        $sequence_9 = { 57 8908 894804 894808 8b15???????? }
            // n = 5, score = 100
            //   57                   | mov                 ecx, dword ptr [esi + 0x1c]
            //   8908                 | cmp                 eax, ecx
            //   894804               | mov                 dword ptr [esi + 0x24], 0
            //   894808               | mov                 ecx, 0x30
            //   8b15????????         |                     

        $sequence_10 = { b930000000 33c0 8bfb 33f6 }
            // n = 4, score = 100
            //   b930000000           | mov                 word ptr [esp + 0x12], cx
            //   33c0                 | mov                 word ptr [esp + 0x14], ax
            //   8bfb                 | push                edi
            //   33f6                 | mov                 dword ptr [eax], ecx

        $sequence_11 = { 0f85d8000000 668b4702 663b442412 0f85c9000000 668b4f04 }
            // n = 5, score = 100
            //   0f85d8000000         | xor                 eax, eax
            //   668b4702             | mov                 edi, ebp
            //   663b442412           | mov                 word ptr [esi + 0x64], 0xffff
            //   0f85c9000000         | mov                 eax, dword ptr [esp + 0x12]
            //   668b4f04             | mov                 cx, word ptr [esp + 0x14]

        $sequence_12 = { 8b442412 668b4c2414 66894c2412 6689442414 }
            // n = 4, score = 100
            //   8b442412             | mov                 ecx, dword ptr [eax + 0xf38c4]
            //   668b4c2414           | test                ecx, ecx
            //   66894c2412           | add                 eax, edi
            //   6689442414           | mov                 dword ptr [esi + 4], ecx

        $sequence_13 = { 03c7 894e04 8b4e1c 3bc1 c7462400000000 }
            // n = 5, score = 100
            //   03c7                 | cdq                 
            //   894e04               | idiv                ecx
            //   8b4e1c               | sub                 eax, edx
            //   3bc1                 | sar                 eax, 1
            //   c7462400000000       | cdq                 

        $sequence_14 = { 0bc1 8d0440 c1e003 8b88c4380f00 85c9 }
            // n = 5, score = 100
            //   0bc1                 | dec                 eax
            //   8d0440               | arpl                ax, cx
            //   c1e003               | cdq                 
            //   8b88c4380f00         | sub                 eax, edx
            //   85c9                 | sar                 eax, 1

    condition:
        7 of them and filesize < 3475456
}