rule win_ddkeylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ddkeylogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ddkeylogger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 88140e 0fb611 feca 88140f 83c102 48 }
            // n = 6, score = 200
            //   88140e               | mov                 byte ptr [esi + ecx], dl
            //   0fb611               | movzx               edx, byte ptr [ecx]
            //   feca                 | dec                 dl
            //   88140f               | mov                 byte ptr [edi + ecx], dl
            //   83c102               | add                 ecx, 2
            //   48                   | dec                 eax

        $sequence_1 = { c1eb06 03de 0fb61493 885102 }
            // n = 4, score = 200
            //   c1eb06               | shr                 ebx, 6
            //   03de                 | add                 ebx, esi
            //   0fb61493             | movzx               edx, byte ptr [ebx + edx*4]
            //   885102               | mov                 byte ptr [ecx + 2], dl

        $sequence_2 = { 0fb7f1 57 bfffff0000 c745f400000000 }
            // n = 4, score = 200
            //   0fb7f1               | movzx               esi, cx
            //   57                   | push                edi
            //   bfffff0000           | mov                 edi, 0xffff
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0

        $sequence_3 = { 83c418 8d8de7faffff c745fcffffffff e8???????? 85f6 0f8f14feffff 8b85e0faffff }
            // n = 7, score = 200
            //   83c418               | add                 esp, 0x18
            //   8d8de7faffff         | lea                 ecx, [ebp - 0x519]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   0f8f14feffff         | jg                  0xfffffe1a
            //   8b85e0faffff         | mov                 eax, dword ptr [ebp - 0x520]

        $sequence_4 = { 8bce eb99 53 8b1d???????? 6a00 ffd3 }
            // n = 6, score = 200
            //   8bce                 | mov                 ecx, esi
            //   eb99                 | jmp                 0xffffff9b
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   6a00                 | push                0
            //   ffd3                 | call                ebx

        $sequence_5 = { 83c8ff e9???????? 8bc6 c1f805 8bfe 53 8d1c8580ee4500 }
            // n = 7, score = 200
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8bfe                 | mov                 edi, esi
            //   53                   | push                ebx
            //   8d1c8580ee4500       | lea                 ebx, [eax*4 + 0x45ee80]

        $sequence_6 = { 83f801 8bc7 7508 8a4c0bff 884c3bff c6043b00 5f }
            // n = 7, score = 200
            //   83f801               | cmp                 eax, 1
            //   8bc7                 | mov                 eax, edi
            //   7508                 | jne                 0xa
            //   8a4c0bff             | mov                 cl, byte ptr [ebx + ecx - 1]
            //   884c3bff             | mov                 byte ptr [ebx + edi - 1], cl
            //   c6043b00             | mov                 byte ptr [ebx + edi], 0
            //   5f                   | pop                 edi

        $sequence_7 = { c1fa05 8b149580ee4500 c1e006 8d440224 }
            // n = 4, score = 200
            //   c1fa05               | sar                 edx, 5
            //   8b149580ee4500       | mov                 edx, dword ptr [edx*4 + 0x45ee80]
            //   c1e006               | shl                 eax, 6
            //   8d440224             | lea                 eax, [edx + eax + 0x24]

        $sequence_8 = { 7448 f7c200f00000 7420 f7c200c00000 740c f7c200800000 0f95c0 }
            // n = 7, score = 200
            //   7448                 | je                  0x4a
            //   f7c200f00000         | test                edx, 0xf000
            //   7420                 | je                  0x22
            //   f7c200c00000         | test                edx, 0xc000
            //   740c                 | je                  0xe
            //   f7c200800000         | test                edx, 0x8000
            //   0f95c0               | setne               al

        $sequence_9 = { 56 ff15???????? 56 8bf8 ff15???????? 3b3d???????? }
            // n = 6, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   3b3d????????         |                     

    condition:
        7 of them and filesize < 808960
}