rule win_ddkong_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ddkong."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ddkong"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8065d300 8d45c0 50 53 ffd6 50 ffd7 }
            // n = 7, score = 100
            //   8065d300             | and                 byte ptr [ebp - 0x2d], 0
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_1 = { c644241561 c64424166c c644241746 c644241b00 ff15???????? 50 ff15???????? }
            // n = 7, score = 100
            //   c644241561           | mov                 byte ptr [esp + 0x15], 0x61
            //   c64424166c           | mov                 byte ptr [esp + 0x16], 0x6c
            //   c644241746           | mov                 byte ptr [esp + 0x17], 0x46
            //   c644241b00           | mov                 byte ptr [esp + 0x1b], 0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { ebcd 53 53 53 }
            // n = 4, score = 100
            //   ebcd                 | jmp                 0xffffffcf
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_3 = { bb???????? 50 53 c645a457 c645a561 c645a669 }
            // n = 6, score = 100
            //   bb????????           |                     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   c645a457             | mov                 byte ptr [ebp - 0x5c], 0x57
            //   c645a561             | mov                 byte ptr [ebp - 0x5b], 0x61
            //   c645a669             | mov                 byte ptr [ebp - 0x5a], 0x69

        $sequence_4 = { 8d8500ffffff 50 53 ffd7 }
            // n = 4, score = 100
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd7                 | call                edi

        $sequence_5 = { 56 8b35???????? 8d45ec 57 bb???????? 50 53 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8b35????????         |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   57                   | push                edi
            //   bb????????           |                     
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_6 = { c645b474 8d45ac c645b541 50 8d45f0 }
            // n = 5, score = 100
            //   c645b474             | mov                 byte ptr [ebp - 0x4c], 0x74
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   c645b541             | mov                 byte ptr [ebp - 0x4b], 0x41
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_7 = { 8d45a4 bb???????? 50 53 }
            // n = 4, score = 100
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   bb????????           |                     
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_8 = { 7427 837d08ff 7421 8d45dc 6a10 50 ff7508 }
            // n = 7, score = 100
            //   7427                 | je                  0x29
            //   837d08ff             | cmp                 dword ptr [ebp + 8], -1
            //   7421                 | je                  0x23
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   6a10                 | push                0x10
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_9 = { 50 ffd6 898504ffffff 8d45c4 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   898504ffffff         | mov                 dword ptr [ebp - 0xfc], eax
            //   8d45c4               | lea                 eax, [ebp - 0x3c]

    condition:
        7 of them and filesize < 81920
}