rule win_deathransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deathransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deathransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668945d8 8d55d8 8b45f4 52 6a00 68???????? 8b08 }
            // n = 7, score = 100
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   68????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_1 = { 03d6 8bc1 8b75c8 03da c1c00d 8bd1 }
            // n = 6, score = 100
            //   03d6                 | add                 edx, esi
            //   8bc1                 | mov                 eax, ecx
            //   8b75c8               | mov                 esi, dword ptr [ebp - 0x38]
            //   03da                 | add                 ebx, edx
            //   c1c00d               | rol                 eax, 0xd
            //   8bd1                 | mov                 edx, ecx

        $sequence_2 = { 8b75d4 c1c90e 33c8 836dc001 894ddc 894dbc 8b4df8 }
            // n = 7, score = 100
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]
            //   c1c90e               | ror                 ecx, 0xe
            //   33c8                 | xor                 ecx, eax
            //   836dc001             | sub                 dword ptr [ebp - 0x40], 1
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   894dbc               | mov                 dword ptr [ebp - 0x44], ecx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_3 = { ffd7 50 ffd6 ff75d8 6a00 ffd7 50 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   50                   | push                eax

        $sequence_4 = { 894108 eb03 8b7df8 56 6a00 ff15???????? 8b35???????? }
            // n = 7, score = 100
            //   894108               | mov                 dword ptr [ecx + 8], eax
            //   eb03                 | jmp                 5
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b35????????         |                     

        $sequence_5 = { 33c8 8bc3 034dcc 33c6 2345e4 33c3 03c1 }
            // n = 7, score = 100
            //   33c8                 | xor                 ecx, eax
            //   8bc3                 | mov                 eax, ebx
            //   034dcc               | add                 ecx, dword ptr [ebp - 0x34]
            //   33c6                 | xor                 eax, esi
            //   2345e4               | and                 eax, dword ptr [ebp - 0x1c]
            //   33c3                 | xor                 eax, ebx
            //   03c1                 | add                 eax, ecx

        $sequence_6 = { f7d8 837b0400 5f 0f4dc6 5e 894304 5b }
            // n = 7, score = 100
            //   f7d8                 | neg                 eax
            //   837b0400             | cmp                 dword ptr [ebx + 4], 0
            //   5f                   | pop                 edi
            //   0f4dc6               | cmovge              eax, esi
            //   5e                   | pop                 esi
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   5b                   | pop                 ebx

        $sequence_7 = { 894db8 0fb64a38 c1e108 0bc8 0fb6423a c1e108 0bc8 }
            // n = 7, score = 100
            //   894db8               | mov                 dword ptr [ebp - 0x48], ecx
            //   0fb64a38             | movzx               ecx, byte ptr [edx + 0x38]
            //   c1e108               | shl                 ecx, 8
            //   0bc8                 | or                  ecx, eax
            //   0fb6423a             | movzx               eax, byte ptr [edx + 0x3a]
            //   c1e108               | shl                 ecx, 8
            //   0bc8                 | or                  ecx, eax

        $sequence_8 = { 33c8 8b7de4 03ca 8b5df4 8b55dc 8bc6 }
            // n = 6, score = 100
            //   33c8                 | xor                 ecx, eax
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]
            //   03ca                 | add                 ecx, edx
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   8bc6                 | mov                 eax, esi

        $sequence_9 = { 33c2 8b55dc 8945e4 8d0413 c1c007 3345cc 03d0 }
            // n = 7, score = 100
            //   33c2                 | xor                 eax, edx
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8d0413               | lea                 eax, [ebx + edx]
            //   c1c007               | rol                 eax, 7
            //   3345cc               | xor                 eax, dword ptr [ebp - 0x34]
            //   03d0                 | add                 edx, eax

    condition:
        7 of them and filesize < 133120
}