rule win_deepdata_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deepdata."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deepdata"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 751d 68???????? ff15???????? 50 }
            // n = 4, score = 600
            //   751d                 | jne                 0x1f
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_1 = { 83d000 50 51 8bce e8???????? }
            // n = 5, score = 500
            //   83d000               | adc                 eax, 0
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_2 = { b001 5d c3 8ac1 }
            // n = 4, score = 500
            //   b001                 | mov                 al, 1
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8ac1                 | mov                 al, cl

        $sequence_3 = { 8bd0 8bce e8???????? 83c408 5f }
            // n = 5, score = 500
            //   8bd0                 | mov                 edx, eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5f                   | pop                 edi

        $sequence_4 = { 837d0800 7502 eb10 8b4508 a3???????? }
            // n = 5, score = 500
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7502                 | jne                 4
            //   eb10                 | jmp                 0x12
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   a3????????           |                     

        $sequence_5 = { 55 8bec 8b4508 32c9 85c0 }
            // n = 5, score = 500
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   32c9                 | xor                 cl, cl
            //   85c0                 | test                eax, eax

        $sequence_6 = { 740a 50 ff15???????? 83c404 8b8c245c010000 }
            // n = 5, score = 400
            //   740a                 | je                  0xc
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   8b8c245c010000       | mov                 ecx, dword ptr [esp + 0x15c]

        $sequence_7 = { 8bec 56 57 8bf9 8d7704 8bce c707???????? }
            // n = 7, score = 400
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8d7704               | lea                 esi, [edi + 4]
            //   8bce                 | mov                 ecx, esi
            //   c707????????         |                     

        $sequence_8 = { e8???????? 81e3fbff0000 f20f1106 83cb08 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   81e3fbff0000         | and                 ebx, 0xfffb
            //   f20f1106             | movsd               qword ptr [esi], xmm0
            //   83cb08               | or                  ebx, 8

        $sequence_9 = { ff36 e8???????? 83c408 c707???????? f6450801 }
            // n = 5, score = 400
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c707????????         |                     
            //   f6450801             | test                byte ptr [ebp + 8], 1

        $sequence_10 = { 8bec 56 8bf1 c706???????? 8b4e18 83f910 7228 }
            // n = 7, score = 400
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   c706????????         |                     
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   83f910               | cmp                 ecx, 0x10
            //   7228                 | jb                  0x2a

        $sequence_11 = { 83c104 3bd3 7cf2 eb06 32c0 88442425 }
            // n = 6, score = 400
            //   83c104               | add                 ecx, 4
            //   3bd3                 | cmp                 edx, ebx
            //   7cf2                 | jl                  0xfffffff4
            //   eb06                 | jmp                 8
            //   32c0                 | xor                 al, al
            //   88442425             | mov                 byte ptr [esp + 0x25], al

        $sequence_12 = { e8???????? 83c40c c785c4fbffff2c020000 6a00 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c785c4fbffff2c020000     | mov    dword ptr [ebp - 0x43c], 0x22c
            //   6a00                 | push                0

        $sequence_13 = { 7760 8bc2 51 50 e8???????? 83c408 c7463000000000 }
            // n = 7, score = 400
            //   7760                 | ja                  0x62
            //   8bc2                 | mov                 eax, edx
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c7463000000000       | mov                 dword ptr [esi + 0x30], 0

        $sequence_14 = { 64a300000000 8bf1 8b7d08 897dd0 c745d800000000 c745e800000000 c745ec0f000000 }
            // n = 7, score = 400
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf1                 | mov                 esi, ecx
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   897dd0               | mov                 dword ptr [ebp - 0x30], edi
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf

        $sequence_15 = { c78560ffffff00000000 c78564ffffff00000000 c78568ffffff00000000 c7856cffffff00000000 c78550ffffff00000000 c7458800000000 }
            // n = 6, score = 400
            //   c78560ffffff00000000     | mov    dword ptr [ebp - 0xa0], 0
            //   c78564ffffff00000000     | mov    dword ptr [ebp - 0x9c], 0
            //   c78568ffffff00000000     | mov    dword ptr [ebp - 0x98], 0
            //   c7856cffffff00000000     | mov    dword ptr [ebp - 0x94], 0
            //   c78550ffffff00000000     | mov    dword ptr [ebp - 0xb0], 0
            //   c7458800000000       | mov                 dword ptr [ebp - 0x78], 0

        $sequence_16 = { 837df401 7543 68???????? ff15???????? }
            // n = 4, score = 300
            //   837df401             | cmp                 dword ptr [ebp - 0xc], 1
            //   7543                 | jne                 0x45
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_17 = { 8b4dfc e8???????? 8b4dfc e8???????? 8b10 52 8b4dfc }
            // n = 7, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   52                   | push                edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_18 = { 83c40c 83c118 6a08 50 }
            // n = 4, score = 300
            //   83c40c               | add                 esp, 0xc
            //   83c118               | add                 ecx, 0x18
            //   6a08                 | push                8
            //   50                   | push                eax

        $sequence_19 = { e8???????? 8b00 50 8b4dfc e8???????? 8bc8 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_20 = { e8???????? 8b00 50 e8???????? 83c404 2bf0 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   2bf0                 | sub                 esi, eax

        $sequence_21 = { a1???????? 8b4858 ffd1 83c40c }
            // n = 4, score = 300
            //   a1????????           |                     
            //   8b4858               | mov                 ecx, dword ptr [eax + 0x58]
            //   ffd1                 | call                ecx
            //   83c40c               | add                 esp, 0xc

        $sequence_22 = { 83c428 c645fc00 8d4d08 e8???????? c745fcffffffff 8d4d14 e8???????? }
            // n = 7, score = 300
            //   83c428               | add                 esp, 0x28
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d14               | lea                 ecx, [ebp + 0x14]
            //   e8????????           |                     

        $sequence_23 = { e8???????? 83c404 394508 7321 8b4dfc }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   394508               | cmp                 dword ptr [ebp + 8], eax
            //   7321                 | jae                 0x23
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_24 = { 83c40c b001 5f 5b }
            // n = 4, score = 300
            //   83c40c               | add                 esp, 0xc
            //   b001                 | mov                 al, 1
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_25 = { 8bec 83ec08 894dfc 8b4dfc e8???????? 8b00 50 }
            // n = 7, score = 300
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax

        $sequence_26 = { 837df800 7549 837df401 7543 }
            // n = 4, score = 300
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7549                 | jne                 0x4b
            //   837df401             | cmp                 dword ptr [ebp - 0xc], 1
            //   7543                 | jne                 0x45

        $sequence_27 = { 6a00 6a00 ff7514 ff75c8 ff75c0 ff75c4 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff75c8               | push                dword ptr [ebp - 0x38]
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   ff75c4               | push                dword ptr [ebp - 0x3c]

        $sequence_28 = { 8b4dfc e8???????? 8b16 3b10 750a 6a01 }
            // n = 6, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   3b10                 | cmp                 edx, dword ptr [eax]
            //   750a                 | jne                 0xc
            //   6a01                 | push                1

        $sequence_29 = { 8945e4 8b4dec e8???????? 833800 }
            // n = 4, score = 300
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   833800               | cmp                 dword ptr [eax], 0

        $sequence_30 = { 50 8b4d10 8b11 ffd2 83c404 }
            // n = 5, score = 300
            //   50                   | push                eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   ffd2                 | call                edx
            //   83c404               | add                 esp, 4

        $sequence_31 = { 8b4dfc 8b5108 0fb602 50 8b4dfc e8???????? }
            // n = 6, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   50                   | push                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_32 = { 85d2 7526 8d4d90 e8???????? 0fb6c0 85c0 }
            // n = 6, score = 300
            //   85d2                 | test                edx, edx
            //   7526                 | jne                 0x28
            //   8d4d90               | lea                 ecx, [ebp - 0x70]
            //   e8????????           |                     
            //   0fb6c0               | movzx               eax, al
            //   85c0                 | test                eax, eax

        $sequence_33 = { 83c118 e8???????? 8945f8 837df804 7408 837df808 740c }
            // n = 7, score = 300
            //   83c118               | add                 ecx, 0x18
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df804             | cmp                 dword ptr [ebp - 8], 4
            //   7408                 | je                  0xa
            //   837df808             | cmp                 dword ptr [ebp - 8], 8
            //   740c                 | je                  0xe

        $sequence_34 = { 83c00c 6a00 50 e8???????? 84c0 }
            // n = 5, score = 300
            //   83c00c               | add                 eax, 0xc
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_35 = { 8b4dfc 8b5008 3b5104 7505 83c8ff eb1e 8b45fc }
            // n = 7, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   3b5104               | cmp                 edx, dword ptr [ecx + 4]
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb1e                 | jmp                 0x20
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 33134592
}