rule win_defray_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.defray."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.defray"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b86effffff 5e 8be5 5d c3 8d4102 8906 }
            // n = 7, score = 200
            //   b86effffff           | mov                 eax, 0xffffff6e
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d4102               | lea                 eax, [ecx + 2]
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_1 = { 8be5 5d c3 8b4d08 8d041e 5f 5e }
            // n = 7, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d041e               | lea                 eax, [esi + ebx]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 0f84cf020000 83f8ff 0f84c6020000 6880000000 ffd6 50 }
            // n = 6, score = 200
            //   0f84cf020000         | je                  0x2d5
            //   83f8ff               | cmp                 eax, -1
            //   0f84c6020000         | je                  0x2cc
            //   6880000000           | push                0x80
            //   ffd6                 | call                esi
            //   50                   | push                eax

        $sequence_3 = { 83c40c 83601000 8b4df0 68???????? 8d4918 e8???????? 8d45ec }
            // n = 7, score = 200
            //   83c40c               | add                 esp, 0xc
            //   83601000             | and                 dword ptr [eax + 0x10], 0
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   68????????           |                     
            //   8d4918               | lea                 ecx, [ecx + 0x18]
            //   e8????????           |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_4 = { e8???????? f6450801 59 740d 68b8000000 56 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   f6450801             | test                byte ptr [ebp + 8], 1
            //   59                   | pop                 ecx
            //   740d                 | je                  0xf
            //   68b8000000           | push                0xb8
            //   56                   | push                esi

        $sequence_5 = { 66a5 8dbdbefcffff be???????? ab ab ab ab }
            // n = 7, score = 200
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   8dbdbefcffff         | lea                 edi, [ebp - 0x342]
            //   be????????           |                     
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_6 = { 33c0 663b88f0724700 740d 83c002 83f814 72ef 33c0 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   663b88f0724700       | cmp                 cx, word ptr [eax + 0x4772f0]
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2
            //   83f814               | cmp                 eax, 0x14
            //   72ef                 | jb                  0xfffffff1
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 33ff 393d???????? 7e79 33db 6800001000 e8???????? 8bf0 }
            // n = 7, score = 200
            //   33ff                 | xor                 edi, edi
            //   393d????????         |                     
            //   7e79                 | jle                 0x7b
            //   33db                 | xor                 ebx, ebx
            //   6800001000           | push                0x100000
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_8 = { a5 a5 66a5 8dbdbef6ffff be???????? ab ab }
            // n = 7, score = 200
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   8dbdbef6ffff         | lea                 edi, [ebp - 0x942]
            //   be????????           |                     
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_9 = { 0fb7c7 894de8 884dd8 8d4dd8 6a08 8945d4 c745ec0f000000 }
            // n = 7, score = 200
            //   0fb7c7               | movzx               eax, di
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   884dd8               | mov                 byte ptr [ebp - 0x28], cl
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   6a08                 | push                8
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf

    condition:
        7 of them and filesize < 1253376
}