rule win_dented_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dented."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dented"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? bf08020000 8d85ecfbffff 57 }
            // n = 4, score = 400
            //   68????????           |                     
            //   bf08020000           | mov                 edi, 0x208
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   57                   | push                edi

        $sequence_1 = { c1e814 8b4dfc 5f 33cd }
            // n = 4, score = 400
            //   c1e814               | shr                 eax, 0x14
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   33cd                 | xor                 ecx, ebp

        $sequence_2 = { 8d55ff a1???????? 52 885dff 8d4810 }
            // n = 5, score = 400
            //   8d55ff               | lea                 edx, [ebp - 1]
            //   a1????????           |                     
            //   52                   | push                edx
            //   885dff               | mov                 byte ptr [ebp - 1], bl
            //   8d4810               | lea                 ecx, [eax + 0x10]

        $sequence_3 = { 8b35???????? 8d85f8feffff 50 8d85f4fdffff 50 ffd6 }
            // n = 6, score = 400
            //   8b35????????         |                     
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_4 = { 6a01 53 68???????? ffb5e8fbffff ff15???????? }
            // n = 5, score = 400
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   68????????           |                     
            //   ffb5e8fbffff         | push                dword ptr [ebp - 0x418]
            //   ff15????????         |                     

        $sequence_5 = { e8???????? 8364242c00 8d4c2434 807d1c00 c74424300f000000 c644241c00 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   8364242c00           | and                 dword ptr [esp + 0x2c], 0
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   807d1c00             | cmp                 byte ptr [ebp + 0x1c], 0
            //   c74424300f000000     | mov                 dword ptr [esp + 0x30], 0xf
            //   c644241c00           | mov                 byte ptr [esp + 0x1c], 0

        $sequence_6 = { 59 8bf0 8bcf 33c0 89b5e8f7ffff 2185f0f7ffff }
            // n = 6, score = 400
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax
            //   8bcf                 | mov                 ecx, edi
            //   33c0                 | xor                 eax, eax
            //   89b5e8f7ffff         | mov                 dword ptr [ebp - 0x818], esi
            //   2185f0f7ffff         | and                 dword ptr [ebp - 0x810], eax

        $sequence_7 = { 8b85f8f7ffff 8a8485fcfbffff 32c1 880416 8b8decf7ffff 43 42 }
            // n = 7, score = 400
            //   8b85f8f7ffff         | mov                 eax, dword ptr [ebp - 0x808]
            //   8a8485fcfbffff       | mov                 al, byte ptr [ebp + eax*4 - 0x404]
            //   32c1                 | xor                 al, cl
            //   880416               | mov                 byte ptr [esi + edx], al
            //   8b8decf7ffff         | mov                 ecx, dword ptr [ebp - 0x814]
            //   43                   | inc                 ebx
            //   42                   | inc                 edx

        $sequence_8 = { c21000 55 8bec 81ec18040000 a1???????? 33c5 8945fc }
            // n = 7, score = 400
            //   c21000               | ret                 0x10
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec18040000         | sub                 esp, 0x418
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_9 = { 5f 57 8d45b8 6a00 50 }
            // n = 5, score = 400
            //   5f                   | pop                 edi
            //   57                   | push                edi
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   6a00                 | push                0
            //   50                   | push                eax

    condition:
        7 of them and filesize < 450560
}