rule win_derusbi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.derusbi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.derusbi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 75be 8b45c8 895db0 895dac 3bc3 0f84affeffff }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   75be                 | jne                 0xffffffc0
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   895db0               | mov                 dword ptr [ebp - 0x50], ebx
            //   895dac               | mov                 dword ptr [ebp - 0x54], ebx
            //   3bc3                 | cmp                 eax, ebx
            //   0f84affeffff         | je                  0xfffffeb5

        $sequence_1 = { 72e4 5e c3 55 8bec 51 53 }
            // n = 7, score = 200
            //   72e4                 | jb                  0xffffffe6
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_2 = { 6810040000 ff15???????? 8985f8fdffff 85c0 7464 }
            // n = 5, score = 200
            //   6810040000           | push                0x410
            //   ff15????????         |                     
            //   8985f8fdffff         | mov                 dword ptr [ebp - 0x208], eax
            //   85c0                 | test                eax, eax
            //   7464                 | je                  0x66

        $sequence_3 = { ff7508 ff15???????? 8bf0 59 85f6 740f ff7508 }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   85f6                 | test                esi, esi
            //   740f                 | je                  0x11
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_4 = { 56 89442418 57 8d442424 50 8d44242c 50 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   57                   | push                edi
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   8d44242c             | lea                 eax, [esp + 0x2c]
            //   50                   | push                eax

        $sequence_5 = { 83c108 3d00040000 72f1 e9???????? 215cc70c 8d5cc710 }
            // n = 6, score = 200
            //   83c108               | add                 ecx, 8
            //   3d00040000           | cmp                 eax, 0x400
            //   72f1                 | jb                  0xfffffff3
            //   e9????????           |                     
            //   215cc70c             | and                 dword ptr [edi + eax*8 + 0xc], ebx
            //   8d5cc710             | lea                 ebx, [edi + eax*8 + 0x10]

        $sequence_6 = { 50 ff15???????? 83c40c 56 8d4c2470 51 889c2407010000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   8d4c2470             | lea                 ecx, [esp + 0x70]
            //   51                   | push                ecx
            //   889c2407010000       | mov                 byte ptr [esp + 0x107], bl

        $sequence_7 = { 83c40c 8d45dc 50 ff15???????? 83f8ff 740d a810 }
            // n = 7, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   740d                 | je                  0xf
            //   a810                 | test                al, 0x10

        $sequence_8 = { 53 50 ffd6 83c40c 8d442424 50 8d84242cbc0200 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   8d84242cbc0200       | lea                 eax, [esp + 0x2bc2c]

        $sequence_9 = { 8d85b8f7ffff e8???????? 59 33c9 85c0 7e25 80b40db8fbffff99 }
            // n = 7, score = 200
            //   8d85b8f7ffff         | lea                 eax, [ebp - 0x848]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   33c9                 | xor                 ecx, ecx
            //   85c0                 | test                eax, eax
            //   7e25                 | jle                 0x27
            //   80b40db8fbffff99     | xor                 byte ptr [ebp + ecx - 0x448], 0x99

    condition:
        7 of them and filesize < 360448
}