rule win_dharma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dharma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dharma"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8b5510 52 8b450c 50 8b4df0 c1e105 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   c1e105               | shl                 ecx, 5

        $sequence_1 = { c1ea10 81e2ff000000 8b048db8b34000 330495b8b74000 }
            // n = 4, score = 100
            //   c1ea10               | shr                 edx, 0x10
            //   81e2ff000000         | and                 edx, 0xff
            //   8b048db8b34000       | mov                 eax, dword ptr [ecx*4 + 0x40b3b8]
            //   330495b8b74000       | xor                 eax, dword ptr [edx*4 + 0x40b7b8]

        $sequence_2 = { 50 e8???????? 83c408 c785c4fdffff01000000 8b8dd4fdffff 51 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c785c4fdffff01000000     | mov    dword ptr [ebp - 0x23c], 1
            //   8b8dd4fdffff         | mov                 ecx, dword ptr [ebp - 0x22c]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { 51 8b55fc 52 ff15???????? 8b4df8 89048db8864100 8b55f8 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   89048db8864100       | mov                 dword ptr [ecx*4 + 0x4186b8], eax
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_4 = { 8b4508 8b4d08 8908 c745f801000000 8b5510 c70201000000 8b45f8 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 51 6a00 8b55ec 52 e8???????? 83c40c 8b45ec }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_6 = { 8b45fc 50 e8???????? 50 6a00 }
            // n = 5, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_7 = { 50 8b4d10 51 8d95e0fdffff 52 e8???????? 83c410 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   8d95e0fdffff         | lea                 edx, [ebp - 0x220]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_8 = { 8b4d08 0fb6548121 8b8590feffff 0b9485b8feffff 8b8d90feffff 89948db8feffff }
            // n = 6, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb6548121           | movzx               edx, byte ptr [ecx + eax*4 + 0x21]
            //   8b8590feffff         | mov                 eax, dword ptr [ebp - 0x170]
            //   0b9485b8feffff       | or                  edx, dword ptr [ebp + eax*4 - 0x148]
            //   8b8d90feffff         | mov                 ecx, dword ptr [ebp - 0x170]
            //   89948db8feffff       | mov                 dword ptr [ebp + ecx*4 - 0x148], edx

        $sequence_9 = { 68feff0000 e8???????? 83c404 8945ac e8???????? 8945d0 6a02 }
            // n = 7, score = 100
            //   68feff0000           | push                0xfffe
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   e8????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   6a02                 | push                2

    condition:
        7 of them and filesize < 204800
}