rule win_diavol_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.diavol."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.diavol"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8be5 5d c3 8d85c8fbffff 50 56 c785c8fbffff2c020000 }
            // n = 7, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d85c8fbffff         | lea                 eax, [ebp - 0x438]
            //   50                   | push                eax
            //   56                   | push                esi
            //   c785c8fbffff2c020000     | mov    dword ptr [ebp - 0x438], 0x22c

        $sequence_1 = { 3bc3 72d8 8d8da0fdffff 68???????? 51 68???????? 8bd1 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   72d8                 | jb                  0xffffffda
            //   8d8da0fdffff         | lea                 ecx, [ebp - 0x260]
            //   68????????           |                     
            //   51                   | push                ecx
            //   68????????           |                     
            //   8bd1                 | mov                 edx, ecx

        $sequence_2 = { 83f8ff 752c 6a02 53 ff15???????? 53 ff15???????? }
            // n = 7, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   752c                 | jne                 0x2e
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_3 = { 8d740004 56 e8???????? 83c404 56 8d95f8fdffff }
            // n = 6, score = 100
            //   8d740004             | lea                 esi, [eax + eax + 4]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   8d95f8fdffff         | lea                 edx, [ebp - 0x208]

        $sequence_4 = { 0f84d4000000 6800040000 8d95f8f9ffff 6a00 52 }
            // n = 5, score = 100
            //   0f84d4000000         | je                  0xda
            //   6800040000           | push                0x400
            //   8d95f8f9ffff         | lea                 edx, [ebp - 0x608]
            //   6a00                 | push                0
            //   52                   | push                edx

        $sequence_5 = { 668b08 83c002 6685c9 75f5 8dbdf4efffff 2bc2 83c7fe }
            // n = 7, score = 100
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8dbdf4efffff         | lea                 edi, [ebp - 0x100c]
            //   2bc2                 | sub                 eax, edx
            //   83c7fe               | add                 edi, -2

        $sequence_6 = { 56 ff15???????? 57 e8???????? a1???????? 8b4dd0 8d1448 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   a1????????           |                     
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   8d1448               | lea                 edx, [eax + ecx*2]

        $sequence_7 = { 8b8d38c2ffff 8d953cc2ffff 52 8d8540c2ffff 6a00 50 }
            // n = 6, score = 100
            //   8b8d38c2ffff         | mov                 ecx, dword ptr [ebp - 0x3dc8]
            //   8d953cc2ffff         | lea                 edx, [ebp - 0x3dc4]
            //   52                   | push                edx
            //   8d8540c2ffff         | lea                 eax, [ebp - 0x3dc0]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_8 = { 8be5 5d c3 8d8405c0fbffff }
            // n = 4, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d8405c0fbffff       | lea                 eax, [ebp + eax - 0x440]

        $sequence_9 = { 8be5 5d c3 b902000000 6a50 }
            // n = 5, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   b902000000           | mov                 ecx, 2
            //   6a50                 | push                0x50

    condition:
        7 of them and filesize < 191488
}