rule win_diceloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.diceloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.diceloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bcb e8???????? 4c634518 488d4c2420 4c03c3 41ffd0 }
            // n = 6, score = 100
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   4c634518             | mov                 dword ptr [ebx], ebx
            //   488d4c2420           | jmp                 0xd03
            //   4c03c3               | dec                 eax
            //   41ffd0               | mov                 eax, dword ptr [eax]

        $sequence_1 = { ff15???????? 488bd7 488d0d14260000 e8???????? }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   488bd7               | dec                 eax
            //   488d0d14260000       | test                eax, eax
            //   e8????????           |                     

        $sequence_2 = { 8b5710 4c8d054f250000 488b4f08 41b91f000000 e8???????? }
            // n = 5, score = 100
            //   8b5710               | mov                 eax, 0x1000
            //   4c8d054f250000       | inc                 ebp
            //   488b4f08             | xor                 edi, edi
            //   41b91f000000         | inc                 esp
            //   e8????????           |                     

        $sequence_3 = { 448b07 488d1569000000 8b5f04 488d0d4b1e0000 e8???????? 4885c0 7413 }
            // n = 7, score = 100
            //   448b07               | test                esp, esp
            //   488d1569000000       | dec                 ecx
            //   8b5f04               | cmovne              eax, esp
            //   488d0d4b1e0000       | dec                 esp
            //   e8????????           |                     
            //   4885c0               | mov                 esp, eax
            //   7413                 | dec                 ebp

        $sequence_4 = { 0fb6c2 8a13 48c1e804 488b44c430 488941f8 }
            // n = 5, score = 100
            //   0fb6c2               | dec                 eax
            //   8a13                 | mov                 eax, dword ptr [eax + 0x10]
            //   48c1e804             | dec                 eax
            //   488b44c430           | test                eax, eax
            //   488941f8             | je                  0x12d6

        $sequence_5 = { ff15???????? 488b1e 4885db 7420 488b1b 498bd6 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   488b1e               | dec                 eax
            //   4885db               | lea                 eax, [esi + 8]
            //   7420                 | inc                 ecx
            //   488b1b               | mov                 byte ptr [esi + 0xd], bl
            //   498bd6               | inc                 ecx

        $sequence_6 = { 440f4fe8 48035d48 418bd5 488d4b30 e8???????? 418bd5 8945e0 }
            // n = 7, score = 100
            //   440f4fe8             | dec                 eax
            //   48035d48             | sub                 eax, edx
            //   418bd5               | dec                 eax
            //   488d4b30             | add                 ecx, edi
            //   e8????????           |                     
            //   418bd5               | dec                 ecx
            //   8945e0               | mul                 ecx

        $sequence_7 = { 488dac2450faffff 4881ecb0060000 4c8d3d7b250000 c705????????00000000 }
            // n = 4, score = 100
            //   488dac2450faffff     | jne                 0x275
            //   4881ecb0060000       | dec                 esp
            //   4c8d3d7b250000       | mov                 ebx, dword ptr [esp + 0xa0]
            //   c705????????00000000     |     

        $sequence_8 = { 448b541620 8b5c1624 4c03d2 4803da 4533c9 458d7901 458b02 }
            // n = 7, score = 100
            //   448b541620           | dec                 eax
            //   8b5c1624             | lea                 ecx, [0x2a12]
            //   4c03d2               | dec                 eax
            //   4803da               | cmp                 ebx, ecx
            //   4533c9               | jl                  0x12e9
            //   458d7901             | inc                 ebp
            //   458b02               | xor                 ecx, ecx

        $sequence_9 = { 488bda 448bc1 488d1561ffffff 488d0d761d0000 e8???????? }
            // n = 5, score = 100
            //   488bda               | cmp                 byte ptr [esi], cl
            //   448bc1               | add                 al, bl
            //   488d1561ffffff       | mov                 byte ptr [ebp + 0x61], al
            //   488d0d761d0000       | inc                 ebp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 41984
}