rule win_dimnie_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dimnie."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dimnie"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb04 c645af3d 8b4d0c 8a55af 885102 837d1002 }
            // n = 6, score = 400
            //   eb04                 | jmp                 6
            //   c645af3d             | mov                 byte ptr [ebp - 0x51], 0x3d
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8a55af               | mov                 dl, byte ptr [ebp - 0x51]
            //   885102               | mov                 byte ptr [ecx + 2], dl
            //   837d1002             | cmp                 dword ptr [ebp + 0x10], 2

        $sequence_1 = { 7e28 8b5508 0fb64201 83e00f c1e002 8b4d08 0fb65102 }
            // n = 7, score = 400
            //   7e28                 | jle                 0x2a
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fb64201             | movzx               eax, byte ptr [edx + 1]
            //   83e00f               | and                 eax, 0xf
            //   c1e002               | shl                 eax, 2
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb65102             | movzx               edx, byte ptr [ecx + 2]

        $sequence_2 = { 8b450c eb54 8b550c 2b5508 83fa01 751c 0f31 }
            // n = 7, score = 400
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   eb54                 | jmp                 0x56
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   2b5508               | sub                 edx, dword ptr [ebp + 8]
            //   83fa01               | cmp                 edx, 1
            //   751c                 | jne                 0x1e
            //   0f31                 | rdtsc               

        $sequence_3 = { c70201000000 8b4508 8b08 83e10f 8b5508 }
            // n = 5, score = 400
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   83e10f               | and                 ecx, 0xf
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_4 = { eb54 8b550c 2b5508 83fa01 751c }
            // n = 5, score = 400
            //   eb54                 | jmp                 0x56
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   2b5508               | sub                 edx, dword ptr [ebp + 8]
            //   83fa01               | cmp                 edx, 1
            //   751c                 | jne                 0x1e

        $sequence_5 = { eb61 8b4d08 3b4d0c 7605 8b450c eb54 8b550c }
            // n = 7, score = 400
            //   eb61                 | jmp                 0x63
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3b4d0c               | cmp                 ecx, dword ptr [ebp + 0xc]
            //   7605                 | jbe                 7
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   eb54                 | jmp                 0x56
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_6 = { c70201000000 8b4508 8b08 83e10f 8b5508 890a }
            // n = 6, score = 400
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   83e10f               | and                 ecx, 0xf
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   890a                 | mov                 dword ptr [edx], ecx

        $sequence_7 = { 8855ae eb04 c645ae3d 8b450c 8a4dae }
            // n = 5, score = 400
            //   8855ae               | mov                 byte ptr [ebp - 0x52], dl
            //   eb04                 | jmp                 6
            //   c645ae3d             | mov                 byte ptr [ebp - 0x52], 0x3d
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8a4dae               | mov                 cl, byte ptr [ebp - 0x52]

        $sequence_8 = { b90d000000 be???????? 8d7dbc f3a5 }
            // n = 4, score = 400
            //   b90d000000           | mov                 ecx, 0xd
            //   be????????           |                     
            //   8d7dbc               | lea                 edi, [ebp - 0x44]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_9 = { 8b4d0c 8a55af 885102 837d1002 7e13 8b4508 }
            // n = 6, score = 400
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8a55af               | mov                 dl, byte ptr [ebp - 0x51]
            //   885102               | mov                 byte ptr [ecx + 2], dl
            //   837d1002             | cmp                 dword ptr [ebp + 0x10], 2
            //   7e13                 | jle                 0x15
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 212992
}