rule win_disk_knight_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.disk_knight."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.disk_knight"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 8b45c8 50 ff15???????? 8945ac eb07 c745ac00000000 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   eb07                 | jmp                 9
            //   c745ac00000000       | mov                 dword ptr [ebp - 0x54], 0

        $sequence_1 = { 8bd0 8d4dd4 ffd6 50 68???????? ffd7 8d4d8c }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]

        $sequence_2 = { ff15???????? 8bd0 8d4da0 ffd6 8d45a4 50 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   ffd6                 | call                esi
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { c7458001000080 33d2 8d4db0 ff15???????? ba???????? 8d4db4 ff15???????? }
            // n = 7, score = 100
            //   c7458001000080       | mov                 dword ptr [ebp - 0x80], 0x80000001
            //   33d2                 | xor                 edx, edx
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   ff15????????         |                     
            //   ba????????           |                     
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   ff15????????         |                     

        $sequence_4 = { 8b16 8d8578ffffff 50 56 ff92b8070000 3bc7 7d0e }
            // n = 7, score = 100
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff92b8070000         | call                dword ptr [edx + 0x7b8]
            //   3bc7                 | cmp                 eax, edi
            //   7d0e                 | jge                 0x10

        $sequence_5 = { 8975c8 8d4db0 ff15???????? 8b4dc8 33ff 3bcf 741c }
            // n = 7, score = 100
            //   8975c8               | mov                 dword ptr [ebp - 0x38], esi
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   ff15????????         |                     
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   33ff                 | xor                 edi, edi
            //   3bcf                 | cmp                 ecx, edi
            //   741c                 | je                  0x1e

        $sequence_6 = { 83bdc4feffff00 7d23 6a58 68???????? 8b8dc8feffff 51 8b95c4feffff }
            // n = 7, score = 100
            //   83bdc4feffff00       | cmp                 dword ptr [ebp - 0x13c], 0
            //   7d23                 | jge                 0x25
            //   6a58                 | push                0x58
            //   68????????           |                     
            //   8b8dc8feffff         | mov                 ecx, dword ptr [ebp - 0x138]
            //   51                   | push                ecx
            //   8b95c4feffff         | mov                 edx, dword ptr [ebp - 0x13c]

        $sequence_7 = { 8d55dc 51 52 897d80 c78578ffffff00000000 89bd70ffffff ff15???????? }
            // n = 7, score = 100
            //   8d55dc               | lea                 edx, [ebp - 0x24]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   897d80               | mov                 dword ptr [ebp - 0x80], edi
            //   c78578ffffff00000000     | mov    dword ptr [ebp - 0x88], 0
            //   89bd70ffffff         | mov                 dword ptr [ebp - 0x90], edi
            //   ff15????????         |                     

        $sequence_8 = { 6880000000 ff15???????? 83c41c 8b4dc8 51 8d9544ffffff 52 }
            // n = 7, score = 100
            //   6880000000           | push                0x80
            //   ff15????????         |                     
            //   83c41c               | add                 esp, 0x1c
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   51                   | push                ecx
            //   8d9544ffffff         | lea                 edx, [ebp - 0xbc]
            //   52                   | push                edx

        $sequence_9 = { c785bcfeffff01000000 8b4d0c 833900 7455 8b550c 8b02 66833801 }
            // n = 7, score = 100
            //   c785bcfeffff01000000     | mov    dword ptr [ebp - 0x144], 1
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   833900               | cmp                 dword ptr [ecx], 0
            //   7455                 | je                  0x57
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   66833801             | cmp                 word ptr [eax], 1

    condition:
        7 of them and filesize < 868352
}