rule win_dispcashbr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dispcashbr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dispcashbr"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83ec08 c7442408c8ffffff c7442404???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408c8ffffff     | mov                 dword ptr [esp + 8], 0xffffffc8
            //   c7442404????????     |                     

        $sequence_1 = { e8???????? e9???????? c70424f5ffffff e8???????? }
            // n = 4, score = 200
            //   e8????????           |                     
            //   e9????????           |                     
            //   c70424f5ffffff       | mov                 dword ptr [esp], 0xfffffff5
            //   e8????????           |                     

        $sequence_2 = { c744240404000000 890424 e8???????? 83ec08 c7442408f2ffffff }
            // n = 5, score = 200
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408f2ffffff     | mov                 dword ptr [esp + 8], 0xfffffff2

        $sequence_3 = { c744240404000000 890424 e8???????? 83ec08 c7442408c9ffffff c7442404???????? a1???????? }
            // n = 7, score = 200
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408c9ffffff     | mov                 dword ptr [esp + 8], 0xffffffc9
            //   c7442404????????     |                     
            //   a1????????           |                     

        $sequence_4 = { c744240404000000 890424 e8???????? 83ec08 c7442408eaffffff c7442404???????? a1???????? }
            // n = 7, score = 200
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408eaffffff     | mov                 dword ptr [esp + 8], 0xffffffea
            //   c7442404????????     |                     
            //   a1????????           |                     

        $sequence_5 = { 890424 e8???????? 83ec08 c7442408c8ffffff }
            // n = 4, score = 200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408c8ffffff     | mov                 dword ptr [esp + 8], 0xffffffc8

        $sequence_6 = { e8???????? 83ec08 c7442408c9ffffff c7442404???????? a1???????? 83c020 890424 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408c9ffffff     | mov                 dword ptr [esp + 8], 0xffffffc9
            //   c7442404????????     |                     
            //   a1????????           |                     
            //   83c020               | add                 eax, 0x20
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_7 = { c744240404000000 890424 e8???????? 83ec08 c7442408fcffffff c7442404???????? }
            // n = 6, score = 200
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408fcffffff     | mov                 dword ptr [esp + 8], 0xfffffffc
            //   c7442404????????     |                     

        $sequence_8 = { 83c020 8944240c c744240822000000 c744240401000000 c70424???????? e8???????? }
            // n = 6, score = 200
            //   83c020               | add                 eax, 0x20
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   c744240822000000     | mov                 dword ptr [esp + 8], 0x22
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   c70424????????       |                     
            //   e8????????           |                     

        $sequence_9 = { 83ec04 c744240404000000 890424 e8???????? 83ec08 c7442408e6ffffff c7442404???????? }
            // n = 7, score = 200
            //   83ec04               | sub                 esp, 4
            //   c744240404000000     | mov                 dword ptr [esp + 4], 4
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   c7442408e6ffffff     | mov                 dword ptr [esp + 8], 0xffffffe6
            //   c7442404????????     |                     

    condition:
        7 of them and filesize < 123904
}