rule win_dispenserxfs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dispenserxfs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dispenserxfs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 8b4c242c 83c41c 8bc1 }
            // n = 5, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   83c41c               | add                 esp, 0x1c
            //   8bc1                 | mov                 eax, ecx

        $sequence_1 = { 58 6689854affffff 33c0 66898574ffffff 8d45cc }
            // n = 5, score = 200
            //   58                   | pop                 eax
            //   6689854affffff       | mov                 word ptr [ebp - 0xb6], ax
            //   33c0                 | xor                 eax, eax
            //   66898574ffffff       | mov                 word ptr [ebp - 0x8c], ax
            //   8d45cc               | lea                 eax, [ebp - 0x34]

        $sequence_2 = { 75ee 83c004 0fb708 66890f }
            // n = 4, score = 200
            //   75ee                 | jne                 0xfffffff0
            //   83c004               | add                 eax, 4
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   66890f               | mov                 word ptr [edi], cx

        $sequence_3 = { 68???????? e8???????? 59 ff75fc ff15???????? eb0d }
            // n = 6, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   eb0d                 | jmp                 0xf

        $sequence_4 = { 47 84c0 75f8 8bca 8d85f8eeffff c1e902 f3a5 }
            // n = 7, score = 200
            //   47                   | inc                 edi
            //   84c0                 | test                al, al
            //   75f8                 | jne                 0xfffffffa
            //   8bca                 | mov                 ecx, edx
            //   8d85f8eeffff         | lea                 eax, [ebp - 0x1108]
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_5 = { 0f84e6000000 0fb74106 50 0fb74104 50 }
            // n = 5, score = 200
            //   0f84e6000000         | je                  0xec
            //   0fb74106             | movzx               eax, word ptr [ecx + 6]
            //   50                   | push                eax
            //   0fb74104             | movzx               eax, word ptr [ecx + 4]
            //   50                   | push                eax

        $sequence_6 = { 57 8d45f0 8bd9 50 6860ea0000 33f6 895de4 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   8bd9                 | mov                 ebx, ecx
            //   50                   | push                eax
            //   6860ea0000           | push                0xea60
            //   33f6                 | xor                 esi, esi
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx

        $sequence_7 = { 0f8408010000 33f6 8bcb 894df4 663bf2 0f83f8000000 57 }
            // n = 7, score = 200
            //   0f8408010000         | je                  0x10e
            //   33f6                 | xor                 esi, esi
            //   8bcb                 | mov                 ecx, ebx
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   663bf2               | cmp                 si, dx
            //   0f83f8000000         | jae                 0xfe
            //   57                   | push                edi

        $sequence_8 = { 6683f802 750b 8b4c2408 e8???????? eb10 0fb6c1 50 }
            // n = 7, score = 200
            //   6683f802             | cmp                 ax, 2
            //   750b                 | jne                 0xd
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   e8????????           |                     
            //   eb10                 | jmp                 0x12
            //   0fb6c1               | movzx               eax, cl
            //   50                   | push                eax

        $sequence_9 = { 89b544ffffff 89b564ffffff 89b568ffffff 89b56cffffff 89b570ffffff 89b57cffffff }
            // n = 6, score = 200
            //   89b544ffffff         | mov                 dword ptr [ebp - 0xbc], esi
            //   89b564ffffff         | mov                 dword ptr [ebp - 0x9c], esi
            //   89b568ffffff         | mov                 dword ptr [ebp - 0x98], esi
            //   89b56cffffff         | mov                 dword ptr [ebp - 0x94], esi
            //   89b570ffffff         | mov                 dword ptr [ebp - 0x90], esi
            //   89b57cffffff         | mov                 dword ptr [ebp - 0x84], esi

    condition:
        7 of them and filesize < 114688
}