rule win_disttrack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.disttrack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.disttrack"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 6a00 6a00 6848000700 }
            // n = 4, score = 200
            //   52                   | pop                 ecx
            //   6a00                 | ret                 
            //   6a00                 | push                0x10
            //   6848000700           | push                7

        $sequence_1 = { e8???????? 83c404 50 e8???????? 83c404 68???????? ff15???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | cmp                 dword ptr [ecx + 0x48], edi
            //   50                   | cmove               edx, eax
            //   e8????????           |                     
            //   83c404               | jmp                 0x13
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_2 = { 53 ff15???????? 5d 5b 8bc7 5f 5e }
            // n = 7, score = 200
            //   53                   | dec                 eax
            //   ff15????????         |                     
            //   5d                   | mov                 eax, dword ptr [ecx + 0x48]
            //   5b                   | dec                 eax
            //   8bc7                 | neg                 eax
            //   5f                   | sbb                 edx, edx
            //   5e                   | dec                 eax

        $sequence_3 = { ff15???????? 8d45dc 50 ff15???????? 8b4ddc }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8d45dc               | lea                 esi, [0x122a7]
            //   50                   | dec                 eax
            //   ff15????????         |                     
            //   8b4ddc               | mov                 ecx, esi

        $sequence_4 = { 57 e8???????? 6a07 e8???????? 59 c3 6a10 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a07                 | push                7
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   6a10                 | push                0x10

        $sequence_5 = { 8b4204 8d8c24a4000000 894c2420 c7440434fcc24100 8d4c244c }
            // n = 5, score = 100
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8d8c24a4000000       | lea                 ecx, [esp + 0xa4]
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx
            //   c7440434fcc24100     | mov                 dword ptr [esp + eax + 0x34], 0x41c2fc
            //   8d4c244c             | lea                 ecx, [esp + 0x4c]

        $sequence_6 = { ff15???????? 85c0 7406 8b4df0 51 ffd0 83ffff }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | push                ecx
            //   7406                 | add                 esp, 4
            //   8b4df0               | mov                 byte ptr [ebp - 0x15], al
            //   51                   | push                edx
            //   ffd0                 | push                0
            //   83ffff               | push                0

        $sequence_7 = { 0f85a5000000 33d2 488d4c2470 448d4268 }
            // n = 4, score = 100
            //   0f85a5000000         | dec                 eax
            //   33d2                 | mov                 ecx, dword ptr [ebp + 0x280]
            //   488d4c2470           | dec                 eax
            //   448d4268             | xor                 ecx, esp

        $sequence_8 = { 83c1ff 898d14f8ffff 8b9514f8ffff 8a4201 888513f8ffff }
            // n = 5, score = 100
            //   83c1ff               | pop                 esi
            //   898d14f8ffff         | add                 esp, 4
            //   8b9514f8ffff         | push                eax
            //   8a4201               | add                 esp, 4
            //   888513f8ffff         | lea                 eax, [ebp - 0x24]

        $sequence_9 = { 48397d10 7430 488b4c2430 e8???????? 4c8bc0 488b542430 }
            // n = 6, score = 100
            //   48397d10             | mov                 eax, 0x12010
            //   7430                 | dec                 eax
            //   488b4c2430           | mov                 ecx, ebp
            //   e8????????           |                     
            //   4c8bc0               | dec                 eax
            //   488b542430           | cmp                 dword ptr [ebp + 0x10], edi

        $sequence_10 = { 740c 837d1800 7406 837d1c00 751f }
            // n = 5, score = 100
            //   740c                 | pop                 ecx
            //   837d1800             | ret                 
            //   7406                 | push                0x10
            //   837d1c00             | add                 esp, 4
            //   751f                 | push                eax

        $sequence_11 = { 8d8424fc000000 50 8d4c2450 e8???????? }
            // n = 4, score = 100
            //   8d8424fc000000       | lea                 eax, [esp + 0xfc]
            //   50                   | push                eax
            //   8d4c2450             | lea                 ecx, [esp + 0x50]
            //   e8????????           |                     

        $sequence_12 = { 0f87260a0000 ff248597fa4000 33c0 838df4fbffffff }
            // n = 4, score = 100
            //   0f87260a0000         | push                ebx
            //   ff248597fa4000       | pop                 ebp
            //   33c0                 | pop                 ebx
            //   838df4fbffffff       | mov                 eax, edi

        $sequence_13 = { 32040e 6a00 8d55f0 52 }
            // n = 4, score = 100
            //   32040e               | push                0x70048
            //   6a00                 | add                 esp, 4
            //   8d55f0               | push                eax
            //   52                   | add                 esp, 4

        $sequence_14 = { 85c0 750e 80fb2b 7409 80fb2f 0f858c000000 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10
            //   80fb2b               | cmp                 bl, 0x2b
            //   7409                 | je                  0xb
            //   80fb2f               | cmp                 bl, 0x2f
            //   0f858c000000         | jne                 0x92

        $sequence_15 = { 488d9c1de0010000 448be6 48895c2428 4963cc }
            // n = 4, score = 100
            //   488d9c1de0010000     | dec                 eax
            //   448be6               | mov                 edx, dword ptr [esp + 0x30]
            //   48895c2428           | inc                 eax
            //   4963cc               | mov                 al, bh

        $sequence_16 = { e8???????? 85c0 75de 488bcb ff15???????? 33c0 488b8c2460020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   75de                 | lea                 ebx, [esp + 0x390]
            //   488bcb               | dec                 ecx
            //   ff15????????         |                     
            //   33c0                 | mov                 ebx, dword ptr [ebx + 0x10]
            //   488b8c2460020000     | dec                 eax

        $sequence_17 = { 83c804 48397948 0f44d0 eb0e 488b4148 48f7d8 1bd2 }
            // n = 7, score = 100
            //   83c804               | dec                 eax
            //   48397948             | mov                 dword ptr [esp + 0x28], ebx
            //   0f44d0               | dec                 ecx
            //   eb0e                 | arpl                sp, cx
            //   488b4148             | jne                 0xab
            //   48f7d8               | xor                 edx, edx
            //   1bd2                 | dec                 eax

        $sequence_18 = { e8???????? 68???????? 8d4df4 51 c745f408f34100 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4df4               | pop                 edi
            //   51                   | pop                 esi
            //   c745f408f34100       | lea                 eax, [ebp - 0x24]
            //   e8????????           |                     

        $sequence_19 = { 85c0 751a 488d156cb10000 41b810200100 488bcd e8???????? }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   488d156cb10000       | dec                 eax
            //   41b810200100         | lea                 edx, [0xb16c]
            //   488bcd               | inc                 ecx
            //   e8????????           |                     

        $sequence_20 = { c1fe05 c1e106 030cb540174200 eb02 8bca f641247f 759b }
            // n = 7, score = 100
            //   c1fe05               | sar                 esi, 5
            //   c1e106               | shl                 ecx, 6
            //   030cb540174200       | add                 ecx, dword ptr [esi*4 + 0x421740]
            //   eb02                 | jmp                 4
            //   8bca                 | mov                 ecx, edx
            //   f641247f             | test                byte ptr [ecx + 0x24], 0x7f
            //   759b                 | jne                 0xffffff9d

        $sequence_21 = { 33f6 56 51 50 52 e8???????? 8945b8 }
            // n = 7, score = 100
            //   33f6                 | add                 esp, 4
            //   56                   | push                ebx
            //   51                   | pop                 ebp
            //   50                   | pop                 ebx
            //   52                   | mov                 eax, edi
            //   e8????????           |                     
            //   8945b8               | pop                 edi

        $sequence_22 = { c745fc00000000 e8???????? c745fcffffffff 8b5790 8b4204 c7443890b4c24100 }
            // n = 6, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b5790               | mov                 edx, dword ptr [edi - 0x70]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   c7443890b4c24100     | mov                 dword ptr [eax + edi - 0x70], 0x41c2b4

        $sequence_23 = { 8d5c0002 e8???????? 488d542430 448bd8 }
            // n = 4, score = 100
            //   8d5c0002             | lea                 ebx, [ebp + ebx + 0x1e0]
            //   e8????????           |                     
            //   488d542430           | inc                 esp
            //   448bd8               | mov                 esp, esi

        $sequence_24 = { 8b0c8d40174200 83e61f c1e606 89040e 8b45f8 e9???????? }
            // n = 6, score = 100
            //   8b0c8d40174200       | mov                 ecx, dword ptr [ecx*4 + 0x421740]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   89040e               | mov                 dword ptr [esi + ecx], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e9????????           |                     

        $sequence_25 = { e8???????? 408ac7 488b8d80020000 4833cc e8???????? 4c8d9c2490030000 498b5b10 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   408ac7               | je                  0x36
            //   488b8d80020000       | dec                 eax
            //   4833cc               | mov                 ecx, dword ptr [esp + 0x30]
            //   e8????????           |                     
            //   4c8d9c2490030000     | dec                 esp
            //   498b5b10             | mov                 eax, eax

        $sequence_26 = { 8b149540174200 59 c1e006 59 8a4dff 80c901 884c0204 }
            // n = 7, score = 100
            //   8b149540174200       | mov                 edx, dword ptr [edx*4 + 0x421740]
            //   59                   | pop                 ecx
            //   c1e006               | shl                 eax, 6
            //   59                   | pop                 ecx
            //   8a4dff               | mov                 cl, byte ptr [ebp - 1]
            //   80c901               | or                  cl, 1
            //   884c0204             | mov                 byte ptr [edx + eax + 4], cl

    condition:
        7 of them and filesize < 1112064
}