rule win_divergent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.divergent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.divergent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 781e 8d85f8fdffff 50 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   781e                 | js                  0x20
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax

        $sequence_1 = { 50 e8???????? 59 59 8b0b 8bd7 eb08 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   8bd7                 | mov                 edx, edi
            //   eb08                 | jmp                 0xa

        $sequence_2 = { 6aff 0f44c1 50 57 ff15???????? 8bf0 85f6 }
            // n = 7, score = 300
            //   6aff                 | push                -1
            //   0f44c1               | cmove               eax, ecx
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_3 = { 68???????? eb37 68???????? eb30 68???????? eb29 68???????? }
            // n = 7, score = 300
            //   68????????           |                     
            //   eb37                 | jmp                 0x39
            //   68????????           |                     
            //   eb30                 | jmp                 0x32
            //   68????????           |                     
            //   eb29                 | jmp                 0x2b
            //   68????????           |                     

        $sequence_4 = { f77dfc 43 8aca 81fb00010000 7cba 5f 5e }
            // n = 7, score = 300
            //   f77dfc               | idiv                dword ptr [ebp - 4]
            //   43                   | inc                 ebx
            //   8aca                 | mov                 cl, dl
            //   81fb00010000         | cmp                 ebx, 0x100
            //   7cba                 | jl                  0xffffffbc
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { 786e ff75e0 ff15???????? 40 50 e8???????? 8bf0 }
            // n = 7, score = 300
            //   786e                 | js                  0x70
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ff15????????         |                     
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { eb03 8b7dfc 8b36 85f6 0f8574ffffff }
            // n = 5, score = 300
            //   eb03                 | jmp                 5
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   85f6                 | test                esi, esi
            //   0f8574ffffff         | jne                 0xffffff7a

        $sequence_7 = { e8???????? ff730c 68???????? 56 e8???????? f20f104310 83c420 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   ff730c               | push                dword ptr [ebx + 0xc]
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   f20f104310           | movsd               xmm0, qword ptr [ebx + 0x10]
            //   83c420               | add                 esp, 0x20

        $sequence_8 = { 894dd4 894dd8 ff15???????? 33db 85c0 0f99c3 85db }
            // n = 7, score = 300
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   ff15????????         |                     
            //   33db                 | xor                 ebx, ebx
            //   85c0                 | test                eax, eax
            //   0f99c3               | setns               bl
            //   85db                 | test                ebx, ebx

        $sequence_9 = { d9e0 dec1 dd5df8 dd45f8 8be5 5d c3 }
            // n = 7, score = 300
            //   d9e0                 | fchs                
            //   dec1                 | faddp               st(1)
            //   dd5df8               | fstp                qword ptr [ebp - 8]
            //   dd45f8               | fld                 qword ptr [ebp - 8]
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 212992
}